/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The personal data of a user.")
public class PixelContextUser {
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="external_id")
    private String externalId = null;
    @JsonProperty(value="phone_number")
    private String phoneNumber = null;
    @JsonProperty(value="ttp")
    private String ttp = null;

    public PixelContextUser email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="The email of the customer if available. It must be hashed with SHA256 on the client side.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public PixelContextUser externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(description="Any unique identifier on the advertisers side, such as loyalty membership IDs, user IDs, and external cookie IDs. It must be hashed with SHA256 on the client side.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public PixelContextUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(description="The phone number of the customer if available. It must be hashed with SHA256 on the client side.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PixelContextUser ttp(String ttp) {
        this.ttp = ttp;
        return this;
    }

    @Schema(description="Cookie ID. If you also use Pixel SDK and enabled cookie, Pixel SDK automatically saves a unique identifier in the _ttp cookie. The value of _ttp is used to match website visitor events with TikTok ads. You can extract the value of _ttp and attach the value here. For details, see [Set up TikTok Click ID and Cookies](https://ads.tiktok.com/marketing_api/docs?id=1739584860883969)")
    public String getTtp() {
        return this.ttp;
    }

    public void setTtp(String ttp) {
        this.ttp = ttp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelContextUser pixelContextUser = (PixelContextUser)o;
        return Objects.equals(this.email, pixelContextUser.email) && Objects.equals(this.externalId, pixelContextUser.externalId) && Objects.equals(this.phoneNumber, pixelContextUser.phoneNumber) && Objects.equals(this.ttp, pixelContextUser.ttp);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.externalId, this.phoneNumber, this.ttp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PixelContextUser {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    ttp: ").append(this.toIndentedString(this.ttp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

