/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.PixelContent;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Properties associated with the event")
public class PixelProperties {
    @JsonProperty(value="contents")
    private List<PixelContent> contents = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="query")
    private String query = null;
    @JsonProperty(value="value")
    private BigDecimal value = null;

    public PixelProperties contents(List<PixelContent> contents) {
        this.contents = contents;
        return this;
    }

    public PixelProperties addContentsItem(PixelContent contentsItem) {
        if (this.contents == null) {
            this.contents = new ArrayList<PixelContent>();
        }
        this.contents.add(contentsItem);
        return this;
    }

    @Schema(description="Related items in a web event (e.g. items added in an Initiate Checkout event).")
    public List<PixelContent> getContents() {
        return this.contents;
    }

    public void setContents(List<PixelContent> contents) {
        this.contents = contents;
    }

    public PixelProperties currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Schema(description="ISO 4217 code. Examples: EUR, USD, JPY. List of currencies currently supported: AED, ARS, AUD, BDT, BHD, BIF, BOB, BRL, CAD, CHF, CLP, CNY, COP, CRC, CZK, DKK, DZD, EGP, EUR, GBP, GTQ, HKD, HNL, HUF, IDR, ILS, INR, ISK, JPY, KES, KHR, KRW, KWD, KZT, MAD, MOP, MXN, MYR, NGN, NIO, NOK, NZD, OMR, PEN, PHP, PHP, PKR, PLN, PYG, QAR, RON, RUB, SAR, SEK, SGD, THB, TRY, TWD, UAH, USD, VES, VND, ZAR.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PixelProperties description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the item or page.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PixelProperties query(String query) {
        this.query = query;
        return this;
    }

    @Schema(description="The text string that was input by a user. For instance, if a person searches for a product on your website, you can forward the keyword being searched. If a person enters a coupon code at check out, you can forward the code.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public PixelProperties value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Schema(description="Value of the order or items sold. Note: Price is the price for a single item, and value is the total price of the order. For example, if you have two items each sold for $10, the price parameter would pass 10 and the value parameter would pass 20.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelProperties pixelProperties = (PixelProperties)o;
        return Objects.equals(this.contents, pixelProperties.contents) && Objects.equals(this.currency, pixelProperties.currency) && Objects.equals(this.description, pixelProperties.description) && Objects.equals(this.query, pixelProperties.query) && Objects.equals(this.value, pixelProperties.value);
    }

    public int hashCode() {
        return Objects.hash(this.contents, this.currency, this.description, this.query, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PixelProperties {\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

