/*
 * Decompiled with CFR 0.152.
 */
package business_api_client;

import business_api_client.PixelContext;
import business_api_client.PixelProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class PixelTrackBody {
    @JsonProperty(value="context")
    private PixelContext context = null;
    @JsonProperty(value="event")
    private String event = null;
    @JsonProperty(value="event_id")
    private String eventId = null;
    @JsonProperty(value="pixel_code")
    private String pixelCode = null;
    @JsonProperty(value="properties")
    private PixelProperties properties = null;
    @JsonProperty(value="timestamp")
    private String timestamp = null;

    public PixelTrackBody context(PixelContext context) {
        this.context = context;
        return this;
    }

    @Schema(description="")
    public PixelContext getContext() {
        return this.context;
    }

    public void setContext(PixelContext context) {
        this.context = context;
    }

    public PixelTrackBody event(String event) {
        this.event = event;
        return this;
    }

    @Schema(required=true, description="Conversion event name. Please refer to the above `Supported web events section` for accepted event names.")
    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public PixelTrackBody eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(description="Any string or hashed ID that can identify a unique event. This is required if you are sending overlapping events from both TikTok Pixel and Events API.  Please check the [deduplication](https://ads.tiktok.com/marketing_api/docs?id=1739584864945154) subsection for details and complete the setup. Some examples are: 1. RandomNumber 2. OrderID (for CompletePayment event) 3. SessionID_RandomNumber 4. ExternalID_RandomNumber 5. BrowserID_RandomNumber ")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public PixelTrackBody pixelCode(String pixelCode) {
        this.pixelCode = pixelCode;
        return this;
    }

    @Schema(required=true, description="Pixel ID that can be found in events manager of the TikTok ads platform. For details, see the [Where to Find pixel_code](https://ads.tiktok.com/marketing_api/docs?id=1739584855420929) section")
    public String getPixelCode() {
        return this.pixelCode;
    }

    public void setPixelCode(String pixelCode) {
        this.pixelCode = pixelCode;
    }

    public PixelTrackBody properties(PixelProperties properties) {
        this.properties = properties;
        return this;
    }

    @Schema(description="")
    public PixelProperties getProperties() {
        return this.properties;
    }

    public void setProperties(PixelProperties properties) {
        this.properties = properties;
    }

    public PixelTrackBody timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Schema(description="Timestamp that the event took place. Timestamp with ISO 8601 format. See ISO_8601. Please note, if timestamp is not provided, the time when TikTok receives the event via the server will be used.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelTrackBody pixelTrackBody = (PixelTrackBody)o;
        return Objects.equals(this.context, pixelTrackBody.context) && Objects.equals(this.event, pixelTrackBody.event) && Objects.equals(this.eventId, pixelTrackBody.eventId) && Objects.equals(this.pixelCode, pixelTrackBody.pixelCode) && Objects.equals(this.properties, pixelTrackBody.properties) && Objects.equals(this.timestamp, pixelTrackBody.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.event, this.eventId, this.pixelCode, this.properties, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PixelTrackBody {\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    pixelCode: ").append(this.toIndentedString(this.pixelCode)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

