/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import business_api.ApiClient;
import business_api.ApiException;
import business_api.Configuration;
import business_api.Pair;
import business_api.Response;
import business_api.SDKException;
import business_api.SDKExceptionForEvent;
import business_api_client.AdAcoBody;
import business_api_client.AdAcoUpdateBody;
import business_api_client.InlineResponse200;
import business_api_client.MaterialStatusUpdateBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AdAcoApi {
    private ApiClient apiClient;

    public AdAcoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdAcoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Response adAcoCreate(String accessToken, AdAcoBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdAcoBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adAcoCreate");
        }
        String localVarPath = "/open_api/v1.3/ad/aco/create/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adAcoGet(String advertiserId, List<String> adgroupIds, String accessToken, List<String> excludeFieldTypesInResponse) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling adAcoGet");
        }
        if (adgroupIds == null) {
            throw new ApiException(400, "Missing the required parameter 'adgroupIds' when calling adAcoGet");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adAcoGet");
        }
        String localVarPath = "/open_api/v1.3/ad/aco/get/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "exclude_field_types_in_response", excludeFieldTypesInResponse));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "adgroup_ids", adgroupIds));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adAcoMaterialStatusUpdate(String accessToken, MaterialStatusUpdateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        MaterialStatusUpdateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adAcoMaterialStatusUpdate");
        }
        String localVarPath = "/open_api/v1.3/ad/aco/material_status/update/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adAcoUpdate(String accessToken, AdAcoUpdateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdAcoUpdateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adAcoUpdate");
        }
        String localVarPath = "/open_api/v1.3/ad/aco/update/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }
}

