/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import business_api.ApiClient;
import business_api.ApiException;
import business_api.Configuration;
import business_api.Pair;
import business_api.Response;
import business_api.SDKException;
import business_api.SDKExceptionForEvent;
import business_api_client.AdCreateBody;
import business_api_client.AdStatusUpdateBody;
import business_api_client.AdUpdateBody;
import business_api_client.FilteringAdGet;
import business_api_client.InlineResponse200;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AdApi {
    private ApiClient apiClient;

    public AdApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Response adCreate(String accessToken, AdCreateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdCreateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adCreate");
        }
        String localVarPath = "/open_api/v1.3/ad/create/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adGet(String advertiserId, String accessToken, FilteringAdGet filtering, Integer page, Integer pageSize, List<String> fields) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling adGet");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adGet");
        }
        String localVarPath = "/open_api/v1.3/ad/get/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filtering", filtering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adStatusUpdate(String accessToken, AdStatusUpdateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdStatusUpdateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adStatusUpdate");
        }
        String localVarPath = "/open_api/v1.3/ad/status/update/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adUpdate(String accessToken, AdUpdateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdUpdateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adUpdate");
        }
        String localVarPath = "/open_api/v1.3/ad/update/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }
}

