/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import business_api.ApiClient;
import business_api.ApiException;
import business_api.Configuration;
import business_api.Pair;
import business_api.Response;
import business_api.SDKException;
import business_api.SDKExceptionForEvent;
import business_api_client.AdgroupCreateBody;
import business_api_client.AdgroupStatusUpdateBody;
import business_api_client.AdgroupUpdateBody;
import business_api_client.FilteringAdgroupGet;
import business_api_client.InlineResponse200;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AdgroupApi {
    private ApiClient apiClient;

    public AdgroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdgroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Response adgroupCreate(String accessToken, AdgroupCreateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdgroupCreateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adgroupCreate");
        }
        String localVarPath = "/open_api/v1.3/adgroup/create/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adgroupGet(String advertiserId, String accessToken, FilteringAdgroupGet filtering, Integer page, Integer pageSize, List<String> fields) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling adgroupGet");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adgroupGet");
        }
        String localVarPath = "/open_api/v1.3/adgroup/get/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filtering", filtering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adgroupStatusUpdate(String accessToken, AdgroupStatusUpdateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdgroupStatusUpdateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adgroupStatusUpdate");
        }
        String localVarPath = "/open_api/v1.3/adgroup/status/update/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adgroupUpdate(String accessToken, AdgroupUpdateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        AdgroupUpdateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adgroupUpdate");
        }
        String localVarPath = "/open_api/v1.3/adgroup/update/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }
}

