/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import business_api.ApiClient;
import business_api.ApiException;
import business_api.Configuration;
import business_api.Pair;
import business_api.Response;
import business_api.SDKException;
import business_api.SDKExceptionForEvent;
import business_api_client.FilteringVideoAdSearch;
import business_api_client.InlineResponse200;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class FileApi {
    private ApiClient apiClient;

    public FileApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FileApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Response adImageInfo(String advertiserId, List<String> imageIds, String accessToken) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling adImageInfo");
        }
        if (imageIds == null) {
            throw new ApiException(400, "Missing the required parameter 'imageIds' when calling adImageInfo");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adImageInfo");
        }
        String localVarPath = "/open_api/v1.3/file/image/ad/info/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "image_ids", imageIds));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adImageUpload(String accessToken, String advertiserId, String fileId, String fileName, File imageFile, String imageSignature, String imageUrl, String uploadType) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        Object localVarPostBody = null;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adImageUpload");
        }
        String localVarPath = "/open_api/v1.3/file/image/ad/upload/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if (advertiserId != null) {
            localVarFormParams.put("advertiser_id", advertiserId);
        }
        if (fileId != null) {
            localVarFormParams.put("file_id", fileId);
        }
        if (fileName != null) {
            localVarFormParams.put("file_name", fileName);
        }
        if (imageFile != null) {
            localVarFormParams.put("image_file", imageFile);
        }
        if (imageSignature != null) {
            localVarFormParams.put("image_signature", imageSignature);
        }
        if (imageUrl != null) {
            localVarFormParams.put("image_url", imageUrl);
        }
        if (uploadType != null) {
            localVarFormParams.put("upload_type", uploadType);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adVideoInfo(String advertiserId, List<String> videoIds, String accessToken) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling adVideoInfo");
        }
        if (videoIds == null) {
            throw new ApiException(400, "Missing the required parameter 'videoIds' when calling adVideoInfo");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adVideoInfo");
        }
        String localVarPath = "/open_api/v1.3/file/video/ad/info/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "video_ids", videoIds));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adVideoSearch(String advertiserId, String accessToken, FilteringVideoAdSearch filtering, Integer page, Integer pageSize) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling adVideoSearch");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adVideoSearch");
        }
        String localVarPath = "/open_api/v1.3/file/video/ad/search/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filtering", filtering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response adVideoUpload(String accessToken, String advertiserId, Boolean autoBindEnabled, Boolean autoFixEnabled, String fileId, String fileName, Boolean flawDetect, Boolean isThirdParty, String uploadType, File videoFile, String videoId, String videoSignature, String videoUrl) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        Object localVarPostBody = null;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling adVideoUpload");
        }
        String localVarPath = "/open_api/v1.3/file/video/ad/upload/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if (advertiserId != null) {
            localVarFormParams.put("advertiser_id", advertiserId);
        }
        if (autoBindEnabled != null) {
            localVarFormParams.put("auto_bind_enabled", autoBindEnabled);
        }
        if (autoFixEnabled != null) {
            localVarFormParams.put("auto_fix_enabled", autoFixEnabled);
        }
        if (fileId != null) {
            localVarFormParams.put("file_id", fileId);
        }
        if (fileName != null) {
            localVarFormParams.put("file_name", fileName);
        }
        if (flawDetect != null) {
            localVarFormParams.put("flaw_detect", flawDetect);
        }
        if (isThirdParty != null) {
            localVarFormParams.put("is_third_party", isThirdParty);
        }
        if (uploadType != null) {
            localVarFormParams.put("upload_type", uploadType);
        }
        if (videoFile != null) {
            localVarFormParams.put("video_file", videoFile);
        }
        if (videoId != null) {
            localVarFormParams.put("video_id", videoId);
        }
        if (videoSignature != null) {
            localVarFormParams.put("video_signature", videoSignature);
        }
        if (videoUrl != null) {
            localVarFormParams.put("video_url", videoUrl);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }
}

