/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import business_api.ApiClient;
import business_api.ApiException;
import business_api.Configuration;
import business_api.Pair;
import business_api.Response;
import business_api.SDKException;
import business_api.SDKExceptionForEvent;
import business_api_client.IdentityCreateBody;
import business_api_client.InlineResponse200;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class IdentityApi {
    private ApiClient apiClient;

    public IdentityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Response identityCreate(String accessToken, IdentityCreateBody body) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        IdentityCreateBody localVarPostBody = body;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling identityCreate");
        }
        String localVarPath = "/open_api/v1.3/identity/create/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        InlineResponse200 response = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){});
        if (response.getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response identityGet(String advertiserId, String accessToken, String identityType, String identityAuthorizedBcId, Integer page, Integer pageSize) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling identityGet");
        }
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling identityGet");
        }
        String localVarPath = "/open_api/v1.3/identity/get/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identity_type", identityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identity_authorized_bc_id", identityAuthorizedBcId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }

    public Response identityVideoInfo(String accessToken, String advertiserId, String identityType, String identityId, String itemId, String identityAuthorizedBcId) throws ApiException, SDKException, SDKExceptionForEvent {
        GenericType<InlineResponse200> localVarReturnType;
        String[] localVarAuthNames;
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        InlineResponse200 response;
        Object localVarPostBody = null;
        if (accessToken == null) {
            throw new ApiException(400, "Missing the required parameter 'accessToken' when calling identityVideoInfo");
        }
        if (advertiserId == null) {
            throw new ApiException(400, "Missing the required parameter 'advertiserId' when calling identityVideoInfo");
        }
        if (identityType == null) {
            throw new ApiException(400, "Missing the required parameter 'identityType' when calling identityVideoInfo");
        }
        if (identityId == null) {
            throw new ApiException(400, "Missing the required parameter 'identityId' when calling identityVideoInfo");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling identityVideoInfo");
        }
        String localVarPath = "/open_api/v1.3/identity/video/info/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "advertiser_id", advertiserId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identity_type", identityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identity_id", identityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "identity_authorized_bc_id", identityAuthorizedBcId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "item_id", itemId));
        if (accessToken != null) {
            localVarHeaderParams.put("Access-Token", this.apiClient.parameterToString(accessToken));
        }
        if ((response = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"}), localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes = new String[0]), localVarAuthNames = new String[0], localVarReturnType = new GenericType<InlineResponse200>(){})).getCode() != 0L) {
            if (localVarPath.startsWith("/open_api/v1.3/pixel")) {
                throw new SDKExceptionForEvent(response.getRequestId(), response.getCode(), response.getMessage(), response.getData());
            }
            throw new SDKException(response.getRequestId(), response.getCode(), response.getMessage());
        }
        Response return_response = new Response();
        return_response.setData(response.getData());
        return_response.setRequestId(response.getRequestId());
        return return_response;
    }
}

