/*
 * Decompiled with CFR 0.152.
 */
package io.github.jav.exposerversdk;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.github.jav.exposerversdk.ExpoMessageSound;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"_debug"})
public class ExpoPushMessage
implements JsonSerializable {
    @JsonProperty(value="to")
    public List<String> to = null;
    @JsonProperty(value="data")
    public Map<String, String> data = null;
    @JsonProperty(value="title")
    public String title = null;
    @JsonProperty(value="subtitle")
    public String subtitle = null;
    @JsonProperty(value="body")
    public String body = null;
    @JsonProperty(value="sound")
    public ExpoMessageSound sound = null;
    @JsonProperty(value="ttl")
    public long ttl = -1L;
    @JsonProperty(value="expiration")
    public long expiration = -1L;
    @JsonProperty(value="priority")
    private String priority = null;
    @JsonProperty(value="badge")
    public long badge = -1L;
    @JsonProperty(value="channelId")
    public String channelId = null;

    public ExpoPushMessage() {
        this.to = new ArrayList<String>();
    }

    public ExpoPushMessage(List<String> _to, ExpoPushMessage _message) {
        this.to = _to;
        this.data = _message.data;
        this.title = _message.title;
        this.subtitle = _message.subtitle;
        this.body = _message.body;
        this.sound = _message.sound;
        this.ttl = _message.ttl;
        this.expiration = _message.expiration;
        this.priority = _message.priority;
        this.badge = _message.badge;
        this.channelId = _message.channelId;
    }

    public ExpoPushMessage(List<String> _to) {
        this.to = _to;
    }

    public ExpoPushMessage(String _to) {
        this.to = Arrays.asList(_to);
    }

    @JsonProperty(value="to")
    public List<String> getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo(List<String> to) {
        this.to = to;
    }

    @JsonProperty(value="data")
    public Map<String, String> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    @JsonProperty(value="subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="body")
    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty(value="sound")
    public ExpoMessageSound getSound() {
        return this.sound;
    }

    @JsonProperty(value="sound")
    public void setSound(ExpoMessageSound sound) {
        this.sound = sound;
    }

    @JsonProperty(value="ttl")
    public long getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="ttl")
    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    @JsonProperty(value="expiration")
    public long getExpiration() {
        return this.expiration;
    }

    @JsonProperty(value="expiration")
    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    @JsonProperty(value="badge")
    public long getBadge() {
        return this.badge;
    }

    @JsonProperty(value="badge")
    public void setBadge(long badge) {
        this.badge = badge;
    }

    @JsonProperty(value="channelId")
    public String getChannelId() {
        return this.channelId;
    }

    @JsonProperty(value="channelId")
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @JsonProperty(value="priority")
    public void setPriority(String _priority) {
        if (!(null == _priority || _priority.toLowerCase().equals("default") || _priority.toLowerCase().equals("high") || _priority.toLowerCase().equals("normal"))) {
            throw new IllegalArgumentException();
        }
        this.priority = _priority;
    }

    @JsonProperty(value="priority")
    public String getPriority() {
        return this.priority;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (this.to != null) {
            jsonGenerator.writeArrayFieldStart("to");
            for (String recipient : this.to) {
                jsonGenerator.writeString(recipient);
            }
            jsonGenerator.writeEndArray();
        }
        if (this.data != null) {
            jsonGenerator.writeObjectField("data", this.data);
        }
        if (this.title != null) {
            jsonGenerator.writeStringField("title", this.title);
        }
        if (this.subtitle != null) {
            jsonGenerator.writeStringField("subtitle", this.subtitle);
        }
        if (this.body != null) {
            jsonGenerator.writeStringField("body", this.body);
        }
        if (this.sound != null) {
            jsonGenerator.writeObjectField("sound", this.sound);
        }
        if (this.ttl >= 0L) {
            jsonGenerator.writeNumberField("ttl", this.ttl);
        }
        if (this.expiration >= 0L) {
            jsonGenerator.writeNumberField("expiration", this.expiration);
        }
        if (this.priority != null) {
            jsonGenerator.writeStringField("priority", this.priority);
        }
        if (this.badge >= 0L) {
            jsonGenerator.writeNumberField("badge", this.badge);
        }
        if (this.channelId != null) {
            jsonGenerator.writeStringField("channelId", this.channelId);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        throw new UnsupportedOperationException("serializeWithType() not implemented.");
    }
}

