/*
 * Decompiled with CFR 0.152.
 */
package io.github.jav.exposerversdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.jav.exposerversdk.DefaultPushServerResolver;
import io.github.jav.exposerversdk.ExpoPushMessage;
import io.github.jav.exposerversdk.ExpoPushReceiept;
import io.github.jav.exposerversdk.ExpoPushTicket;
import io.github.jav.exposerversdk.PushServerResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class PushClient {
    public static final long PUSH_NOTIFICATION_CHUNK_LIMIT = 100L;
    public static final long PUSH_NOTIFICATION_RECEIPT_CHUNK_LIMIT = 300L;
    public URL baseApiUrl = null;
    public PushServerResolver pushServerResolver = new DefaultPushServerResolver();

    public PushClient() {
        try {
            this.baseApiUrl = new URL("https://exp.host/--/api/v2");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public URL getBaseApiUrl() {
        return this.baseApiUrl;
    }

    public PushClient setBaseApiUrl(URL _baseApiUrl) {
        this.baseApiUrl = _baseApiUrl;
        return this;
    }

    public CompletableFuture<List<ExpoPushTicket>> sendPushNotificationsAsync(List<ExpoPushMessage> messages) {
        try {
            return this._postNotificationAsync(new URL(this.baseApiUrl + "/push/send"), messages).thenApply(jsonString -> {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode dataNode = mapper.readTree((String)jsonString).get("data");
                    ArrayList<ExpoPushTicket> retList = new ArrayList<ExpoPushTicket>();
                    for (JsonNode node : dataNode) {
                        retList.add(mapper.convertValue((Object)node, ExpoPushTicket.class));
                    }
                    return retList;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompletableFuture<List<ExpoPushReceiept>> getPushNotificationReceiptsAsync(List<String> _ids) {
        try {
            return this._postReceiptsAsync(new URL(this.baseApiUrl + "/push/getReceipts"), _ids).thenApply(jsonString -> {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode dataNode = mapper.readTree((String)jsonString).get("data");
                    ArrayList<ExpoPushReceiept> retList = new ArrayList<ExpoPushReceiept>();
                    Iterator<Map.Entry<String, JsonNode>> it = dataNode.fields();
                    while (it.hasNext()) {
                        Map.Entry<String, JsonNode> field = it.next();
                        String key = field.getKey();
                        JsonNode expoPushRecieptJsonNode = field.getValue();
                        ExpoPushReceiept epr = mapper.treeToValue(expoPushRecieptJsonNode, ExpoPushReceiept.class);
                        epr.id = key;
                        retList.add(epr);
                    }
                    return retList;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            });
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected <T> CompletableFuture<String> _postNotificationAsync(URL url, List<T> messages) {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = null;
        try {
            json = objectMapper.writeValueAsString(messages);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return this.pushServerResolver.postAsync(url, json);
    }

    private <T> CompletableFuture<String> _postReceiptsAsync(URL url, List<T> receipts) throws URISyntaxException {
        JsonReceiptHelper<T> jsonReceiptHelper = new JsonReceiptHelper<T>(receipts);
        ObjectMapper objectMapper = new ObjectMapper();
        String json = null;
        try {
            json = objectMapper.writeValueAsString(jsonReceiptHelper);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return this.pushServerResolver.postAsync(url, json);
    }

    public static boolean isExponentPushToken(String token) {
        String prefixA = "ExponentPushToken[";
        String prefixB = "ExpoPushToken[";
        String postfix = "]";
        String regex = "[a-zA-Z0-9]{8}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{12}";
        if (token.matches(regex)) {
            return true;
        }
        if (!token.endsWith(postfix)) {
            return false;
        }
        if (token.startsWith(prefixA)) {
            return true;
        }
        return token.startsWith(prefixB);
    }

    public static long _getActualMessagesCount(List<ExpoPushMessage> messages) {
        return messages.stream().reduce(0, (acc, cur) -> acc + cur.to.size(), Integer::sum).intValue();
    }

    public List<List<String>> chunkPushNotificationReceiptIds(List<String> recieptIds) {
        return this._chunkItems(recieptIds, 300L);
    }

    public <T> List<List<T>> _chunkItems(List<T> items, long chunkSize) {
        ArrayList<List<T>> chunks = new ArrayList<List<T>>();
        ArrayList<T> chunk = new ArrayList<T>();
        for (T item : items) {
            chunk.add(item);
            if ((long)chunk.size() < chunkSize) continue;
            chunks.add(chunk);
            chunk = new ArrayList();
        }
        if (chunk.size() > 0) {
            chunks.add(chunk);
        }
        return chunks;
    }

    public List<List<ExpoPushMessage>> chunkPushNotifications(List<ExpoPushMessage> messages) {
        ArrayList<List<ExpoPushMessage>> chunks = new ArrayList<List<ExpoPushMessage>>();
        ArrayList<ExpoPushMessage> chunk = new ArrayList<ExpoPushMessage>();
        long chunkMessagesCount = 0L;
        for (ExpoPushMessage message : messages) {
            ArrayList<String> partialTo = new ArrayList<String>();
            for (String recipient : message.to) {
                if (recipient.length() <= 0) continue;
                partialTo.add(recipient);
                if (++chunkMessagesCount < 100L) continue;
                chunk.add(new ExpoPushMessage(partialTo, message));
                chunks.add(chunk);
                chunk = new ArrayList();
                chunkMessagesCount = 0L;
                partialTo = new ArrayList();
            }
            if (partialTo.size() > 0) {
                chunk.add(new ExpoPushMessage(partialTo, message));
            }
            if (chunkMessagesCount < 100L) continue;
            chunks.add(chunk);
            chunk = new ArrayList();
            chunkMessagesCount = 0L;
        }
        if (chunkMessagesCount > 0L) {
            chunks.add(chunk);
        }
        return chunks;
    }

    private class JsonReceiptHelper<T> {
        public List<T> ids;

        public JsonReceiptHelper(List<T> _ids) {
            this.ids = _ids;
        }
    }
}

