/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic;

import io.github.javasemantic.JavaSemanticService;
import io.github.javasemantic.commit.engine.CommitEngine;
import io.github.javasemantic.commit.engine.framework.result.EngineResult;
import io.github.javasemantic.commit.retrieval.CommitRetrieval;
import io.github.javasemantic.degenerator.Degenerator;
import io.github.javasemantic.domain.DomainFactory;
import io.github.javasemantic.domain.model.Commit;
import io.github.javasemantic.domain.model.DirtyCommit;
import io.github.javasemantic.domain.model.ProjectData;
import io.github.javasemantic.domain.model.common.CommitComponents;
import io.github.javasemantic.domain.model.common.Version;
import io.github.javasemantic.logging.Log;
import io.github.javasemantic.version.manager.VersionManager;
import java.util.ArrayList;
import org.apache.log4j.BasicConfigurator;

public class JavaSemanticServiceImpl
implements JavaSemanticService {
    private final Degenerator degenerator;
    private final CommitEngine<Commit> commitEngine;
    private final VersionManager versionManager;
    private final CommitRetrieval commitRetrieval;
    private final org.apache.maven.plugin.logging.Log mavenLog;
    private final DirtyCommit lastCommit;

    public void init() {
        BasicConfigurator.configure();
        Log.setMavenLog(this.mavenLog);
    }

    @Override
    public Version execute() {
        this.init();
        ProjectData projectData = DomainFactory.getProjectData();
        ArrayList<DirtyCommit> dirtyCommits = new ArrayList<DirtyCommit>(this.commitRetrieval.getCommits());
        dirtyCommits.add(this.lastCommit);
        for (DirtyCommit dirtyCommit : dirtyCommits) {
            Commit commit = this.createCommit(dirtyCommit);
            EngineResult result = this.commitEngine.execute(commit);
            if (!result.isValid()) continue;
            Log.info(this.getClass(), String.format("Valid Commit: %s, Commit's dirty version: %s", dirtyCommit.getMessage(), commit.getDirtyVersion().toString()));
            projectData.getCommits().add(commit);
        }
        Version projectVersion = this.versionManager.calculateProjectVersion(projectData);
        Log.info(this.getClass(), String.format("Project version: %s", projectVersion.toString()));
        return projectVersion;
    }

    private Commit createCommit(DirtyCommit dirtyCommit) {
        CommitComponents components = this.degenerator.degenerate(dirtyCommit);
        return ((Commit.CommitBuilder)((Commit.CommitBuilder)((Commit.CommitBuilder)Commit.builder().commitComponents(components)).dirtyVersion(DomainFactory.getVersion())).dirtyCommit(dirtyCommit)).build();
    }

    public JavaSemanticServiceImpl(Degenerator degenerator, CommitEngine<Commit> commitEngine, VersionManager versionManager, CommitRetrieval commitRetrieval, org.apache.maven.plugin.logging.Log mavenLog, DirtyCommit lastCommit) {
        this.degenerator = degenerator;
        this.commitEngine = commitEngine;
        this.versionManager = versionManager;
        this.commitRetrieval = commitRetrieval;
        this.mavenLog = mavenLog;
        this.lastCommit = lastCommit;
    }
}

