/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.commit.engine.framework.engine;

import io.github.javasemantic.commit.engine.CommitEngine;
import io.github.javasemantic.commit.engine.framework.result.EngineResult;
import io.github.javasemantic.commit.engine.framework.result.RuleResult;
import io.github.javasemantic.commit.engine.framework.rule.common.BasicRule;
import java.util.ArrayList;
import java.util.List;

public abstract class BasicEngine<RuleType extends BasicRule<Argument>, Argument>
implements CommitEngine<Argument> {
    private final List<RuleResult> history = new ArrayList<RuleResult>();

    @Override
    public EngineResult execute(Argument argument) {
        List<RuleType> rules = this.assignRules();
        this.history.clear();
        for (BasicRule rule : rules) {
            rule.setEngine(this);
            RuleResult result = rule.execute(argument);
            this.addResultToEngine(result);
            if (!result.isInvalid()) continue;
            break;
        }
        return this.createEngineResult();
    }

    private EngineResult createEngineResult() {
        EngineResult result = new EngineResult();
        result.setRuleHistory(this.history);
        return result;
    }

    public void addResultToEngine(RuleResult ruleResult) {
        this.history.add(ruleResult);
    }

    public abstract List<RuleType> assignRules();
}

