/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.commit.engine.framework.result;

import io.github.javasemantic.commit.engine.framework.enums.RuleStatusEnum;

public class RuleResult {
    private RuleStatusEnum status;
    private String ruleName;

    public boolean isAppliedOrValid() {
        return this.status.equals((Object)RuleStatusEnum.APPLIED) || this.status.equals((Object)RuleStatusEnum.VALID);
    }

    public boolean isNotApplicable() {
        return this.status.equals((Object)RuleStatusEnum.NOT_APPLICABLE);
    }

    public boolean isInvalid() {
        return this.status.equals((Object)RuleStatusEnum.INVALID);
    }

    RuleResult(RuleStatusEnum status, String ruleName) {
        this.status = status;
        this.ruleName = ruleName;
    }

    public static RuleResultBuilder builder() {
        return new RuleResultBuilder();
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public static class RuleResultBuilder {
        private RuleStatusEnum status;
        private String ruleName;

        RuleResultBuilder() {
        }

        public RuleResultBuilder status(RuleStatusEnum status) {
            this.status = status;
            return this;
        }

        public RuleResultBuilder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public RuleResult build() {
            return new RuleResult(this.status, this.ruleName);
        }

        public String toString() {
            return "RuleResult.RuleResultBuilder(status=" + this.status + ", ruleName=" + this.ruleName + ")";
        }
    }
}

