/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.commit.engine.framework.rule;

import io.github.javasemantic.commit.engine.framework.enums.RuleStatusEnum;
import io.github.javasemantic.commit.engine.framework.result.RuleResult;
import io.github.javasemantic.commit.engine.framework.rule.ConventionalValidationRule;
import io.github.javasemantic.commit.engine.framework.rule.StructuralValidationRule;
import io.github.javasemantic.commit.engine.framework.rule.VersionRule;
import io.github.javasemantic.commit.engine.framework.rule.common.BasicRule;
import io.github.javasemantic.domain.model.Commit;
import java.util.Objects;

public class CommitPartRule
extends BasicRule<Commit> {
    private ConventionalValidationRule conventionalValidationRule;
    private String conventionalValidationRuleName;
    private StructuralValidationRule structuralValidationRule;
    private String structuralValidationRuleName;
    private VersionRule versionRule;
    private String versionRuleName;
    private RuleResult ruleResult = RuleResult.builder().status(RuleStatusEnum.NOT_APPLICABLE).build();

    @Override
    public RuleResult execute(Commit commit) {
        this.executeAssociatedRule(this.structuralValidationRuleName, this.structuralValidationRule, commit);
        this.executeAssociatedRule(this.conventionalValidationRuleName, this.conventionalValidationRule, commit);
        this.executeAssociatedVersionRule(this.versionRuleName, this.versionRule, commit);
        return this.ruleResult;
    }

    private void executeAssociatedRule(String ruleName, BasicRule<Commit> associatedRule, Commit commit) {
        if (Objects.nonNull(associatedRule) && (this.ruleResult.isAppliedOrValid() || this.ruleResult.isNotApplicable())) {
            this.executeRule(ruleName, associatedRule, commit);
        }
    }

    private void executeAssociatedVersionRule(String ruleName, BasicRule<Commit> associatedRule, Commit commit) {
        if (Objects.nonNull(associatedRule) && this.ruleResult.isAppliedOrValid()) {
            this.executeRule(ruleName, associatedRule, commit);
        }
    }

    private void executeRule(String ruleName, BasicRule<Commit> associatedRule, Commit commit) {
        associatedRule.setEngine(this.engine);
        this.ruleResult = associatedRule.execute(commit);
        this.ruleResult.setRuleName(ruleName);
        this.engine.addResultToEngine(this.ruleResult);
    }

    public CommitPartRule setConventionalValidationRule(String conventionalValidationRuleName, ConventionalValidationRule conventionalValidationRule) {
        this.conventionalValidationRuleName = String.format("Conventional Validation Rule: %s", conventionalValidationRuleName);
        this.conventionalValidationRule = conventionalValidationRule;
        return this;
    }

    public CommitPartRule setStructuralValidationRule(String structuralValidationRuleName, StructuralValidationRule structuralValidationRule) {
        this.structuralValidationRuleName = String.format("Structural Validation Rule: %s", structuralValidationRuleName);
        this.structuralValidationRule = structuralValidationRule;
        return this;
    }

    public CommitPartRule setVersionRule(String versionRuleName, VersionRule versionRule) {
        this.versionRuleName = String.format("Version Rule: %s", versionRuleName);
        this.versionRule = versionRule;
        return this;
    }
}

