/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.commit.engine.rules.commit.type;

import io.github.javasemantic.commit.engine.rules.common.TypeEnum;
import io.github.javasemantic.domain.model.common.CommitComponents;
import java.util.function.Predicate;

public enum TypeRuleEnum {
    FEAT_RULE(commitComponent -> "feat".equals(commitComponent.getType()), TypeEnum.FEAT),
    FEATURE_RULE(commitComponent -> "feature".equals(commitComponent.getType()), TypeEnum.FEAT),
    BREAKING_CHANGE_RULE(commitComponent -> "BREAKING CHANGE".equals(commitComponent.getType()), TypeEnum.BREAKING_CHANGE),
    CHORE_RULE(commitComponent -> "chore".equals(commitComponent.getType()), TypeEnum.CHORE),
    CI_RULE(commitComponent -> "ci".equals(commitComponent.getType()), TypeEnum.CI),
    DEPRECATED_RULE(commitComponent -> "DEPRECATED".equals(commitComponent.getType()), TypeEnum.DEPRECATED),
    BUILD_RULE(commitComponent -> "build".equals(commitComponent.getType()), TypeEnum.BUILD),
    DOCS_RULE(commitComponent -> "docs".equals(commitComponent.getType()), TypeEnum.DOCS),
    FIX_RULE(commitComponent -> "fix".equals(commitComponent.getType()), TypeEnum.FIX),
    PERF_RULE(commitComponent -> "perf".equals(commitComponent.getType()), TypeEnum.PERF),
    REVERT_RULE(commitComponent -> "revert".equals(commitComponent.getType()), TypeEnum.REVERT),
    STYLE_RULE(commitComponent -> "style".equals(commitComponent.getType()), TypeEnum.STYLE),
    TEST_RULE(commitComponent -> "test".equals(commitComponent.getType()), TypeEnum.TEST),
    REFACTOR_RULE(commitComponent -> "refactor".equals(commitComponent.getType()), TypeEnum.REFACTOR);

    private final Predicate<CommitComponents> predicate;
    private final TypeEnum typeEnum;

    public boolean evaluate(CommitComponents commitComponent) {
        return this.predicate.test(commitComponent);
    }

    private TypeRuleEnum(Predicate<CommitComponents> predicate, TypeEnum typeEnum) {
        this.predicate = predicate;
        this.typeEnum = typeEnum;
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }
}

