/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.commit.retrieval;

import io.github.javasemantic.commit.retrieval.CommitRetrieval;
import io.github.javasemantic.domain.model.DirtyCommit;
import io.github.javasemantic.logging.Log;
import io.github.javasemantic.utility.GitRepositoryFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;

public class JgitCommitRetrievalImpl
implements CommitRetrieval {
    private Git git;
    private Repository repository;

    @Override
    public List<DirtyCommit> getCommits() {
        this.init();
        return this.createCommits();
    }

    private void init() {
        this.repository = GitRepositoryFactory.createRepository();
        this.git = new Git(this.repository);
        Log.info(this.getClass(), String.format("Branch detected: %s", GitRepositoryFactory.currentWorkingBranch(this.repository)));
    }

    private List<DirtyCommit> createCommits() {
        List<DirtyCommit> dirtyCommits = this.getDirtyCommits();
        Collections.reverse(dirtyCommits);
        this.logDetectedCommits(dirtyCommits);
        return dirtyCommits;
    }

    private void logDetectedCommits(List<DirtyCommit> dirtyCommits) {
        dirtyCommits.forEach(printableCommit -> Log.info(this.getClass(), printableCommit.getMessage()));
    }

    private List<DirtyCommit> getDirtyCommits() {
        return StreamSupport.stream(this.getRevCommits().spliterator(), false).map(this::buildDirtyCommit).collect(Collectors.toList());
    }

    private DirtyCommit buildDirtyCommit(RevCommit commit) {
        return ((DirtyCommit.DirtyCommitBuilder)((DirtyCommit.DirtyCommitBuilder)DirtyCommit.builder().message(commit.getShortMessage())).footers(this.getFooters(commit.getFooterLines()))).build();
    }

    private void logDetectedCommitsToConsole(List<String> printableCommits) {
        Collections.reverse(printableCommits);
    }

    private List<String> getFooters(List<FooterLine> footerLines) {
        return footerLines.stream().map(FooterLine::toString).collect(Collectors.toList());
    }

    private Iterable<RevCommit> getRevCommits() {
        try {
            return this.git.log().add((AnyObjectId)this.repository.resolve(GitRepositoryFactory.currentWorkingBranch(this.repository))).call();
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

