/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.degenerator;

import io.github.javasemantic.degenerator.Degenerator;
import io.github.javasemantic.domain.model.DirtyCommit;
import io.github.javasemantic.domain.model.common.CommitComponents;
import io.github.javasemantic.utility.ValidConventionalCommitUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DegeneratorImpl
implements Degenerator {
    @Override
    public CommitComponents degenerate(DirtyCommit commit) {
        return this.isValidCommit(commit) ? CommitComponents.builder().type(this.getCommitType(commit)).exclamation(this.getCommitExclamation(commit)).scope(this.getCommitScope(commit)).colon(this.getCommitColon(commit)).whitespace(this.getCommitWhitespace(commit)).description(this.getCommitDescription(commit)).body(this.getCommitFooter(commit)).build() : CommitComponents.builder().type("").exclamation(false).scope("").colon(false).whitespace(false).description("").body(Collections.emptyList()).build();
    }

    private boolean isValidCommit(DirtyCommit commit) {
        return this.hasValidColonFormat(commit) && this.isValidCommitMessage(commit);
    }

    private boolean isValidCommitMessage(DirtyCommit commit) {
        return ValidConventionalCommitUtil.isValid(commit.getMessage());
    }

    private String getCommitType(DirtyCommit commit) {
        String[] preColon = this.getPreColon(commit);
        return this.hasValidColonFormat(commit) ? preColon[0].split("!")[0].split("\\(")[0] : "";
    }

    private List<String> getCommitFooter(DirtyCommit commit) {
        return Objects.nonNull(commit.getFooters()) ? commit.getFooters() : Collections.emptyList();
    }

    private String[] getPreColon(DirtyCommit commit) {
        return commit.getMessage().split(":");
    }

    private boolean getCommitExclamation(DirtyCommit commit) {
        String[] preColon = this.getPreColon(commit);
        return this.hasValidColonFormat(commit) && preColon[0].contains("!");
    }

    private String getCommitScope(DirtyCommit commit) {
        String preColon = this.getPreColon(commit)[0];
        if (preColon.contains("(") && preColon.contains(")")) {
            return preColon.substring(preColon.indexOf("(") + 1, preColon.indexOf(")"));
        }
        return "";
    }

    private boolean getCommitColon(DirtyCommit commit) {
        return this.hasValidColonFormat(commit);
    }

    private boolean getCommitWhitespace(DirtyCommit commit) {
        return this.hasValidColonFormat(commit) && this.getPreColon(commit)[1].indexOf(" ") == 0;
    }

    private String getCommitDescription(DirtyCommit commit) {
        return this.hasValidColonFormat(commit) ? this.getPreColon(commit)[1].trim() : "";
    }

    private boolean hasValidColonFormat(DirtyCommit commit) {
        return this.getPreColon(commit).length >= 2;
    }
}

