/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.domain.model;

import io.github.javasemantic.commit.engine.rules.common.TypeEnum;
import io.github.javasemantic.domain.model.DirtyCommit;
import io.github.javasemantic.domain.model.common.CommitComponents;
import io.github.javasemantic.domain.model.common.Version;

public class Commit {
    private final Version dirtyVersion;
    private final DirtyCommit dirtyCommit;
    private final CommitComponents commitComponents;
    private TypeEnum typeEnum;

    protected Commit(CommitBuilder<?, ?> b) {
        this.dirtyVersion = b.dirtyVersion;
        this.dirtyCommit = b.dirtyCommit;
        this.commitComponents = b.commitComponents;
        this.typeEnum = b.typeEnum;
    }

    public static CommitBuilder<?, ?> builder() {
        return new CommitBuilderImpl();
    }

    public Version getDirtyVersion() {
        return this.dirtyVersion;
    }

    public DirtyCommit getDirtyCommit() {
        return this.dirtyCommit;
    }

    public CommitComponents getCommitComponents() {
        return this.commitComponents;
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(TypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    private static final class CommitBuilderImpl
    extends CommitBuilder<Commit, CommitBuilderImpl> {
        private CommitBuilderImpl() {
        }

        @Override
        protected CommitBuilderImpl self() {
            return this;
        }

        @Override
        public Commit build() {
            return new Commit(this);
        }
    }

    public static abstract class CommitBuilder<C extends Commit, B extends CommitBuilder<C, B>> {
        private Version dirtyVersion;
        private DirtyCommit dirtyCommit;
        private CommitComponents commitComponents;
        private TypeEnum typeEnum;

        protected abstract B self();

        public abstract C build();

        public B dirtyVersion(Version dirtyVersion) {
            this.dirtyVersion = dirtyVersion;
            return this.self();
        }

        public B dirtyCommit(DirtyCommit dirtyCommit) {
            this.dirtyCommit = dirtyCommit;
            return this.self();
        }

        public B commitComponents(CommitComponents commitComponents) {
            this.commitComponents = commitComponents;
            return this.self();
        }

        public B typeEnum(TypeEnum typeEnum) {
            this.typeEnum = typeEnum;
            return this.self();
        }

        public String toString() {
            return "Commit.CommitBuilder(dirtyVersion=" + this.dirtyVersion + ", dirtyCommit=" + this.dirtyCommit + ", commitComponents=" + this.commitComponents + ", typeEnum=" + this.typeEnum + ")";
        }
    }
}

