/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.domain.model.common;

import java.util.List;

public class CommitComponents {
    private String type;
    private boolean exclamation;
    private String scope;
    private boolean colon;
    private boolean whitespace;
    private String description;
    private List<String> body;

    CommitComponents(String type, boolean exclamation, String scope, boolean colon, boolean whitespace, String description, List<String> body) {
        this.type = type;
        this.exclamation = exclamation;
        this.scope = scope;
        this.colon = colon;
        this.whitespace = whitespace;
        this.description = description;
        this.body = body;
    }

    public static CommitComponentsBuilder builder() {
        return new CommitComponentsBuilder();
    }

    public String getType() {
        return this.type;
    }

    public boolean isExclamation() {
        return this.exclamation;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isColon() {
        return this.colon;
    }

    public boolean isWhitespace() {
        return this.whitespace;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getBody() {
        return this.body;
    }

    public static class CommitComponentsBuilder {
        private String type;
        private boolean exclamation;
        private String scope;
        private boolean colon;
        private boolean whitespace;
        private String description;
        private List<String> body;

        CommitComponentsBuilder() {
        }

        public CommitComponentsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public CommitComponentsBuilder exclamation(boolean exclamation) {
            this.exclamation = exclamation;
            return this;
        }

        public CommitComponentsBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public CommitComponentsBuilder colon(boolean colon) {
            this.colon = colon;
            return this;
        }

        public CommitComponentsBuilder whitespace(boolean whitespace) {
            this.whitespace = whitespace;
            return this;
        }

        public CommitComponentsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CommitComponentsBuilder body(List<String> body) {
            this.body = body;
            return this;
        }

        public CommitComponents build() {
            return new CommitComponents(this.type, this.exclamation, this.scope, this.colon, this.whitespace, this.description, this.body);
        }

        public String toString() {
            return "CommitComponents.CommitComponentsBuilder(type=" + this.type + ", exclamation=" + this.exclamation + ", scope=" + this.scope + ", colon=" + this.colon + ", whitespace=" + this.whitespace + ", description=" + this.description + ", body=" + this.body + ")";
        }
    }
}

