/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.domain.model.common;

import io.github.javasemantic.commit.engine.rules.common.ReleaseEnum;
import io.github.javasemantic.commit.engine.rules.common.TypeEnum;

public class Version {
    private Integer major = 0;
    private Integer minor = 0;
    private Integer patch = 0;

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public void addVersion(TypeEnum typeEnum) {
        if (ReleaseEnum.MAJOR.equals((Object)typeEnum.getRelease())) {
            this.major = this.major + 1;
        } else if (ReleaseEnum.MINOR.equals((Object)typeEnum.getRelease())) {
            this.minor = this.minor + 1;
        } else if (ReleaseEnum.PATCH.equals((Object)typeEnum.getRelease())) {
            this.patch = this.patch + 1;
        }
    }

    protected Version(VersionBuilder<?, ?> b) {
        this.major = b.major;
        this.minor = b.minor;
        this.patch = b.patch;
    }

    public static VersionBuilder<?, ?> builder() {
        return new VersionBuilderImpl();
    }

    public Version(Integer major, Integer minor, Integer patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version() {
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public void setMajor(Integer major) {
        this.major = major;
    }

    public void setMinor(Integer minor) {
        this.minor = minor;
    }

    public void setPatch(Integer patch) {
        this.patch = patch;
    }

    private static final class VersionBuilderImpl
    extends VersionBuilder<Version, VersionBuilderImpl> {
        private VersionBuilderImpl() {
        }

        @Override
        protected VersionBuilderImpl self() {
            return this;
        }

        @Override
        public Version build() {
            return new Version(this);
        }
    }

    public static abstract class VersionBuilder<C extends Version, B extends VersionBuilder<C, B>> {
        private Integer major;
        private Integer minor;
        private Integer patch;

        protected abstract B self();

        public abstract C build();

        public B major(Integer major) {
            this.major = major;
            return this.self();
        }

        public B minor(Integer minor) {
            this.minor = minor;
            return this.self();
        }

        public B patch(Integer patch) {
            this.patch = patch;
            return this.self();
        }

        public String toString() {
            return "Version.VersionBuilder(major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ")";
        }
    }
}

