/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.git;

import io.github.javasemantic.git.GitHooker;
import io.github.javasemantic.logging.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;

public class GitHookerImpl
implements GitHooker {
    private static final String GIT_DIR = ".git";
    private static final String HOOKS_DIR = "hooks";

    @Override
    public Path getGitHookPath() {
        Path hooksDirectory = this.getGitRepository().getDirectory().toPath().resolve(HOOKS_DIR);
        if (!Files.exists(hooksDirectory, new LinkOption[0])) {
            Log.info(this.getClass(), "Git hook directory doesn't exist, creating directory " + hooksDirectory);
            try {
                Files.createDirectories(hooksDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return hooksDirectory;
    }

    @Override
    public Repository getGitRepository() {
        try {
            return new FileRepository(GIT_DIR);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

