/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.install.hooks;

import io.github.javasemantic.git.GitFactory;
import io.github.javasemantic.install.hooks.InstallHook;
import io.github.javasemantic.install.hooks.model.InstallHookArguments;
import io.github.javasemantic.install.hooks.other.DefaultExecutableFile;
import io.github.javasemantic.logging.Log;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class InstallHookImpl
implements InstallHook {
    private static final String COMMIT_MSG = "commit-msg";
    private static final String POST_COMMIT = "post-commit";

    @Override
    public void execute(InstallHookArguments installHookArguments) throws IOException {
        Log.info(this.getClass(), "Check if executing from project's root directory.");
        if (!installHookArguments.isExecutionRoot()) {
            throw new RuntimeException("Not executing from project's root directory.");
        }
        Path gitHookDirectory = GitFactory.get().getGitHookPath();
        this.installCommitMsgHook(installHookArguments, gitHookDirectory);
    }

    private void installCommitMsgHook(InstallHookArguments installHookArguments, Path gitHookDirectory) throws IOException {
        DefaultExecutableFile executable = new DefaultExecutableFile(gitHookDirectory.resolve(COMMIT_MSG));
        executable.truncateWithTemplate(() -> this.getClass().getResourceAsStream("/commit-msg"), StandardCharsets.UTF_8.toString(), installHookArguments.getBuildToolAbsolutePath(), installHookArguments.getProjectBuildFile(), installHookArguments.getProjectBaseDirectory());
    }

    private void installPostCommitHook(InstallHookArguments installHookArguments, Path gitHookDirectory) throws IOException {
        DefaultExecutableFile executable = new DefaultExecutableFile(gitHookDirectory.resolve(POST_COMMIT));
        executable.truncateWithTemplate(() -> this.getClass().getResourceAsStream("/post-commit"), StandardCharsets.UTF_8.toString(), installHookArguments.getProjectBaseDirectory(), installHookArguments.getBuildFileName());
    }
}

