/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.install.hooks.model;

import java.nio.file.Path;
import java.util.Arrays;

public class InstallHookArguments {
    private Path projectBuildFile;
    private String artifactId;
    private boolean isExecutionRoot;
    private Path projectBaseDirectory;
    private String[] propertiesToPropagate;
    private String[] propertiesToAdd;
    private String gitLifeCycle;
    private Path buildToolAbsolutePath;
    private String buildFileName;

    InstallHookArguments(Path projectBuildFile, String artifactId, boolean isExecutionRoot, Path projectBaseDirectory, String[] propertiesToPropagate, String[] propertiesToAdd, String gitLifeCycle, Path buildToolAbsolutePath, String buildFileName) {
        this.projectBuildFile = projectBuildFile;
        this.artifactId = artifactId;
        this.isExecutionRoot = isExecutionRoot;
        this.projectBaseDirectory = projectBaseDirectory;
        this.propertiesToPropagate = propertiesToPropagate;
        this.propertiesToAdd = propertiesToAdd;
        this.gitLifeCycle = gitLifeCycle;
        this.buildToolAbsolutePath = buildToolAbsolutePath;
        this.buildFileName = buildFileName;
    }

    public static InstallHookArgumentsBuilder builder() {
        return new InstallHookArgumentsBuilder();
    }

    public Path getProjectBuildFile() {
        return this.projectBuildFile;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public boolean isExecutionRoot() {
        return this.isExecutionRoot;
    }

    public Path getProjectBaseDirectory() {
        return this.projectBaseDirectory;
    }

    public String[] getPropertiesToPropagate() {
        return this.propertiesToPropagate;
    }

    public String[] getPropertiesToAdd() {
        return this.propertiesToAdd;
    }

    public String getGitLifeCycle() {
        return this.gitLifeCycle;
    }

    public Path getBuildToolAbsolutePath() {
        return this.buildToolAbsolutePath;
    }

    public String getBuildFileName() {
        return this.buildFileName;
    }

    public static class InstallHookArgumentsBuilder {
        private Path projectBuildFile;
        private String artifactId;
        private boolean isExecutionRoot;
        private Path projectBaseDirectory;
        private String[] propertiesToPropagate;
        private String[] propertiesToAdd;
        private String gitLifeCycle;
        private Path buildToolAbsolutePath;
        private String buildFileName;

        InstallHookArgumentsBuilder() {
        }

        public InstallHookArgumentsBuilder projectBuildFile(Path projectBuildFile) {
            this.projectBuildFile = projectBuildFile;
            return this;
        }

        public InstallHookArgumentsBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public InstallHookArgumentsBuilder isExecutionRoot(boolean isExecutionRoot) {
            this.isExecutionRoot = isExecutionRoot;
            return this;
        }

        public InstallHookArgumentsBuilder projectBaseDirectory(Path projectBaseDirectory) {
            this.projectBaseDirectory = projectBaseDirectory;
            return this;
        }

        public InstallHookArgumentsBuilder propertiesToPropagate(String[] propertiesToPropagate) {
            this.propertiesToPropagate = propertiesToPropagate;
            return this;
        }

        public InstallHookArgumentsBuilder propertiesToAdd(String[] propertiesToAdd) {
            this.propertiesToAdd = propertiesToAdd;
            return this;
        }

        public InstallHookArgumentsBuilder gitLifeCycle(String gitLifeCycle) {
            this.gitLifeCycle = gitLifeCycle;
            return this;
        }

        public InstallHookArgumentsBuilder buildToolAbsolutePath(Path buildToolAbsolutePath) {
            this.buildToolAbsolutePath = buildToolAbsolutePath;
            return this;
        }

        public InstallHookArgumentsBuilder buildFileName(String buildFileName) {
            this.buildFileName = buildFileName;
            return this;
        }

        public InstallHookArguments build() {
            return new InstallHookArguments(this.projectBuildFile, this.artifactId, this.isExecutionRoot, this.projectBaseDirectory, this.propertiesToPropagate, this.propertiesToAdd, this.gitLifeCycle, this.buildToolAbsolutePath, this.buildFileName);
        }

        public String toString() {
            return "InstallHookArguments.InstallHookArgumentsBuilder(projectBuildFile=" + this.projectBuildFile + ", artifactId=" + this.artifactId + ", isExecutionRoot=" + this.isExecutionRoot + ", projectBaseDirectory=" + this.projectBaseDirectory + ", propertiesToPropagate=" + Arrays.deepToString(this.propertiesToPropagate) + ", propertiesToAdd=" + Arrays.deepToString(this.propertiesToAdd) + ", gitLifeCycle=" + this.gitLifeCycle + ", buildToolAbsolutePath=" + this.buildToolAbsolutePath + ", buildFileName=" + this.buildFileName + ")";
        }
    }
}

