/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.logging;

import io.github.javasemantic.logging.common.LogLevel;
import io.github.javasemantic.logging.common.LogObject;
import java.lang.reflect.Type;
import java.util.Objects;

public class Log {
    private static org.apache.maven.plugin.logging.Log mavenLog = null;
    private static LogLevel assignedLevel = LogLevel.INFO;

    public static void warning(Type type, String message) {
        Log.print(Log.create(LogLevel.WARNING, type, message));
    }

    public static void trace(Type type, String message) {
        Log.print(Log.create(LogLevel.TRACE, type, message));
    }

    public static void debug(Type type, String message) {
        Log.print(Log.create(LogLevel.DEBUG, type, message));
    }

    public static void info(Type type, String message) {
        Log.print(Log.create(LogLevel.INFO, type, message));
    }

    public static void error(Type type, String message) {
        Log.print(Log.create(LogLevel.ERROR, type, message));
    }

    private static LogObject create(LogLevel level, Type type, String message) {
        return ((LogObject.LogObjectBuilder)((LogObject.LogObjectBuilder)((LogObject.LogObjectBuilder)LogObject.builder().level(level)).message(message)).type(type)).build();
    }

    private static void print(LogObject logObject) {
        if (Objects.nonNull(mavenLog)) {
            Log.printMavenPluginLog(logObject);
        } else {
            Log.printHomemadeLog(logObject);
        }
    }

    private static void printHomemadeLog(LogObject logObject) {
        if (logObject.getLevel().getNumericValue() <= assignedLevel.getNumericValue()) {
            System.out.printf("[%s] %s: %s%n", new Object[]{logObject.getLevel(), Log.findClassName(logObject.getType().toString()), logObject.getMessage()});
        }
    }

    private static String findClassName(String type) {
        int lastIndexOf = type.lastIndexOf(".");
        return type.substring(++lastIndexOf);
    }

    private static void printMavenPluginLog(LogObject logObject) {
        String message = String.format("%s: %s", Log.findClassName(logObject.getType().toString()), logObject.getMessage());
        switch (logObject.getLevel()) {
            case ERROR: {
                mavenLog.error((CharSequence)message);
                break;
            }
            case WARNING: {
                mavenLog.warn((CharSequence)message);
                break;
            }
            case INFO: {
                mavenLog.info((CharSequence)message);
                break;
            }
            case DEBUG: 
            case TRACE: {
                mavenLog.debug((CharSequence)message);
            }
        }
    }

    private Log() {
    }

    public static void setMavenLog(org.apache.maven.plugin.logging.Log mavenLog) {
        Log.mavenLog = mavenLog;
    }

    public static void setAssignedLevel(LogLevel assignedLevel) {
        Log.assignedLevel = assignedLevel;
    }
}

