/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.logging.common;

import io.github.javasemantic.logging.common.LogLevel;
import java.lang.reflect.Type;

public class LogObject {
    private final LogLevel level;
    private final String message;
    private final Type type;

    protected LogObject(LogObjectBuilder<?, ?> b) {
        this.level = b.level;
        this.message = b.message;
        this.type = b.type;
    }

    public static LogObjectBuilder<?, ?> builder() {
        return new LogObjectBuilderImpl();
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    private static final class LogObjectBuilderImpl
    extends LogObjectBuilder<LogObject, LogObjectBuilderImpl> {
        private LogObjectBuilderImpl() {
        }

        @Override
        protected LogObjectBuilderImpl self() {
            return this;
        }

        @Override
        public LogObject build() {
            return new LogObject(this);
        }
    }

    public static abstract class LogObjectBuilder<C extends LogObject, B extends LogObjectBuilder<C, B>> {
        private LogLevel level;
        private String message;
        private Type type;

        protected abstract B self();

        public abstract C build();

        public B level(LogLevel level) {
            this.level = level;
            return this.self();
        }

        public B message(String message) {
            this.message = message;
            return this.self();
        }

        public B type(Type type) {
            this.type = type;
            return this.self();
        }

        public String toString() {
            return "LogObject.LogObjectBuilder(level=" + this.level + ", message=" + this.message + ", type=" + this.type + ")";
        }
    }
}

