/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.version.manager;

import io.github.javasemantic.domain.DomainFactory;
import io.github.javasemantic.domain.model.Commit;
import io.github.javasemantic.domain.model.ProjectData;
import io.github.javasemantic.domain.model.common.Version;
import io.github.javasemantic.version.manager.VersionManager;

public class VersionManagerImpl
implements VersionManager {
    private final Version finalProjectVersion = DomainFactory.getVersion();

    @Override
    public Version calculateProjectVersion(ProjectData projectData) {
        for (Commit commit : projectData.getCommits()) {
            this.addVersionToProject(this.normaliseCommit(commit));
        }
        projectData.setProjectVersion(this.finalProjectVersion);
        return projectData.getProjectVersion();
    }

    private Version normaliseCommit(Commit commit) {
        Version commitVersion;
        commitVersion.setMajor((commitVersion = commit.getDirtyVersion()).getMajor() >= 1 ? 1 : 0);
        commitVersion.setMinor(commitVersion.getMinor() >= 1 && commitVersion.getMajor() <= 0 ? 1 : 0);
        commitVersion.setPatch(commitVersion.getPatch() >= 1 && commitVersion.getMajor() <= 0 && commitVersion.getMinor() <= 0 ? 1 : 0);
        return commitVersion;
    }

    private void addVersionToProject(Version commitVersion) {
        if (commitVersion.getMajor() == 1) {
            this.finalProjectVersion.setMajor(this.finalProjectVersion.getMajor() + commitVersion.getMajor());
            this.finalProjectVersion.setMinor(0);
            this.finalProjectVersion.setPatch(0);
        } else if (commitVersion.getMinor() == 1) {
            this.finalProjectVersion.setMinor(this.finalProjectVersion.getMinor() + commitVersion.getMinor());
            this.finalProjectVersion.setPatch(0);
        } else if (commitVersion.getPatch() == 1) {
            this.finalProjectVersion.setPatch(this.finalProjectVersion.getPatch() + commitVersion.getPatch());
        }
    }
}

