/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic.version.updater;

import io.github.javasemantic.logging.Log;
import io.github.javasemantic.version.updater.VersionUpdater;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;

public class MavenVersionUpdater
implements VersionUpdater {
    @Override
    public boolean updateVersion(Path buildToolAbsolutePath, Path projectBuildFile, String version) {
        String command = String.format("%s -f %s versions:set -DnewVersion=%s", buildToolAbsolutePath, projectBuildFile, version);
        Log.debug(MavenVersionUpdater.class, "Updating project version");
        Log.debug(MavenVersionUpdater.class, String.format("Command: %s", command));
        try {
            Process process = Runtime.getRuntime().exec(command);
            this.printProcessToConsole(process);
            Log.debug(MavenVersionUpdater.class, "Updating project version completed");
            return 0 == process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void printProcessToConsole(Process process) throws IOException {
        try (InputStream in = process.getInputStream();){
            this.readLogs(in);
        }
        in = process.getErrorStream();
        try {
            this.readLogs(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void readLogs(InputStream in) throws IOException {
        String line;
        BufferedReader printStream = new BufferedReader(new InputStreamReader(in));
        while ((line = printStream.readLine()) != null) {
            Log.info(MavenVersionUpdater.class, line);
        }
    }

    protected MavenVersionUpdater() {
    }
}

