/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic;

import io.github.javasemantic.JavaSemanticService;
import io.github.javasemantic.JavaSemanticServiceFactory;
import io.github.javasemantic.PathFinder;
import io.github.javasemantic.domain.model.DirtyCommit;
import io.github.javasemantic.domain.model.common.Version;
import io.github.javasemantic.logging.Log;
import io.github.javasemantic.utility.GitRepositoryFactory;
import io.github.javasemantic.utility.ValidConventionalCommitUtil;
import io.github.javasemantic.version.updater.VersionUpdater;
import io.github.javasemantic.version.updater.VersionUpdaterFactory;
import java.nio.file.Path;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="determine-version")
public class DetermineVersionMojo
extends AbstractMojo {
    private final String POM_FILE = "pom.xml";
    private final UnaryOperator<String> systemProperties = System::getProperty;
    @Parameter(defaultValue="${git.commit.message}", required=true)
    private String commitMessage;
    @Parameter(defaultValue="${git.commit.body}", required=true)
    private String commitBody;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject currentProject;
    @Parameter(property="version.override.activate", defaultValue="false", name="activate-override-version")
    private boolean activateOverrideVersion;
    @Parameter(property="version.override", defaultValue="0.0.1-SNAPSHOT", name="override-static-version")
    private String overrideStaticVersion;
    @Parameter(property="override.version.branch.blacklist.items", name="override-version-branch-blacklist-items")
    private List<String> overrideVersionBranchBlacklistItems;

    public void execute() throws MojoExecutionException {
        try {
            this.executeCommitMessageValidation();
            this.executeUpdateVersion();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void executeUpdateVersion() {
        if (this.isOverrideVersion()) {
            this.executePomVersionUpdate(this.overrideStaticVersion);
        } else {
            this.executePomVersionUpdate(this.executeVersionCalculation());
        }
    }

    private boolean isOverrideVersion() {
        String currentWorkingBranch = GitRepositoryFactory.currentWorkingBranch();
        Log.info(((Object)((Object)this)).getClass(), (String)("Current working branch: " + currentWorkingBranch));
        Log.info(((Object)((Object)this)).getClass(), (String)("Black list branches: " + this.overrideVersionBranchBlacklistItems));
        boolean overrideBranch = this.overrideVersionBranchBlacklistItems.stream().noneMatch(currentWorkingBranch::contains);
        return this.activateOverrideVersion && overrideBranch;
    }

    private String executeVersionCalculation() {
        Log.info(((Object)((Object)this)).getClass(), (String)("Last commit message: " + this.commitMessage));
        if (StringUtils.isNotBlank((CharSequence)this.commitBody)) {
            Log.info(((Object)((Object)this)).getClass(), (String)("Last commit body: " + this.commitBody));
        }
        JavaSemanticService service = JavaSemanticServiceFactory.get((org.apache.maven.plugin.logging.Log)this.getLog(), (DirtyCommit)this.buildLastCommit());
        Version version = service.execute();
        return version.toString();
    }

    private void executePomVersionUpdate(String version) {
        VersionUpdater versionUpdater = VersionUpdaterFactory.getMavenVersionUpdater();
        Path mavenBin = PathFinder.findMavenToolPath((String)this.systemProperties.apply("maven.home"), ((Object)((Object)this)).getClass());
        versionUpdater.updateVersion(mavenBin, this.currentProject.getBasedir().toPath(), version);
    }

    private DirtyCommit buildLastCommit() {
        return DirtyCommit.builder().message(this.commitMessage).footers(List.of(this.commitBody)).build();
    }

    private void executeCommitMessageValidation() throws MojoExecutionException {
        boolean result = ValidConventionalCommitUtil.isValid((String)this.commitMessage);
        if (!result) {
            throw new MojoExecutionException(this.commitMessage + ValidConventionalCommitUtil.INVALID_LOG_MESSAGE);
        }
        Log.info(((Object)((Object)this)).getClass(), (String)ValidConventionalCommitUtil.VALID_LOG_MESSAGE);
    }
}

