/*
 * Decompiled with CFR 0.152.
 */
package io.github.javasemantic;

import io.github.javasemantic.PathFinder;
import io.github.javasemantic.install.hooks.InstallHook;
import io.github.javasemantic.install.hooks.InstallHookFactory;
import io.github.javasemantic.install.hooks.model.InstallHookArguments;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="install-hooks", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class InstallHooksMojo
extends AbstractMojo {
    private final UnaryOperator<String> systemProperties = System::getProperty;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject currentProject;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter(property="gcf.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="gcf.skipInstallHooks", defaultValue="false")
    private boolean skipInstallHooks;
    @Parameter(property="gcf.truncateHooksBaseScripts", defaultValue="false")
    private boolean truncateHooksBaseScripts;
    @Parameter(property="gcf.propertiesToPropagate")
    private String[] propertiesToPropagate;
    @Parameter(property="gcf.propertiesToAdd")
    private String[] propertiesToAdd;
    @Parameter(property="gcf.preCommitHookPipeline", defaultValue="")
    private String preCommitHookPipeline;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            InstallHook installHook = InstallHookFactory.get();
            installHook.execute(InstallHookArguments.builder().projectBuildFile(this.getPomFile()).artifactId(this.getArtifactId()).isExecutionRoot(this.isExecutionRoot()).projectBaseDirectory(this.getBaseDirectory()).propertiesToPropagate(this.getMavenPropertiesToPropagate()).propertiesToAdd(this.getMavenPropertiesToAdd()).gitLifeCycle(this.getGitLifeCycle()).buildToolAbsolutePath(this.getMavenExecutable().toAbsolutePath()).buildFileName("pom.xml").build());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public Path getMavenExecutable() {
        return PathFinder.findMavenToolPath((String)this.systemProperties.apply("maven.home"), ((Object)((Object)this)).getClass());
    }

    private Path getPomFile() {
        return this.currentProject.getFile().toPath();
    }

    private String getArtifactId() {
        return this.currentProject.getArtifactId();
    }

    private boolean isExecutionRoot() {
        return this.currentProject.isExecutionRoot();
    }

    private Path getBaseDirectory() {
        return this.currentProject.getBasedir().toPath();
    }

    private String[] getMavenPropertiesToPropagate() {
        return this.propertiesToPropagate;
    }

    private String[] getMavenPropertiesToAdd() {
        return this.propertiesToAdd;
    }

    private String getGitLifeCycle() {
        return this.preCommitHookPipeline;
    }
}

