/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.lombok;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

public class BuilderCustomizer
implements Customizer {
    private final String builderMethodName;
    private final String buildMethodName;

    public BuilderCustomizer() {
        this("builder", "build");
    }

    protected BuilderCustomizer(String builderMethodName, String buildMethodName) {
        this.builderMethodName = builderMethodName;
        this.buildMethodName = buildMethodName;
    }

    public ObjectGenerator customize(ObjectGenerator generator) {
        return (query, context) -> this.getBuilder(query.getType()).map(builder -> this.factory(builder, context)).orElseGet(() -> generator.generate(query, context));
    }

    private Optional<Object> getBuilder(Type type) {
        return type instanceof Class ? this.getBuilder((Class)type) : Optional.empty();
    }

    private Optional<Object> getBuilder(Class<?> type) {
        return Arrays.stream(type.getDeclaredMethods()).filter(method -> method.getName().equals(this.builderMethodName)).filter(method -> Modifier.isStatic(method.getModifiers())).map(method -> BuilderCustomizer.invoke(null, method, new Object[0])).findFirst();
    }

    private ObjectContainer factory(Object builder, ObjectGenerationContext context) {
        BuilderCustomizer.setProperties(builder, context);
        return this.buildObject(builder);
    }

    private static void setProperties(Object builder, ObjectGenerationContext context) {
        Arrays.stream(builder.getClass().getDeclaredMethods()).filter(method -> method.getParameterCount() == 1).forEach(setter -> BuilderCustomizer.setProperty(builder, setter, context));
    }

    private static void setProperty(Object builder, Method setter, ObjectGenerationContext context) {
        ObjectQuery query = () -> setter.getGenericParameterTypes()[0];
        Object argument = context.generate(query);
        BuilderCustomizer.invoke(builder, setter, argument);
    }

    private ObjectContainer buildObject(Object builder) {
        try {
            Method build = builder.getClass().getMethod(this.buildMethodName, new Class[0]);
            return new ObjectContainer(BuilderCustomizer.invoke(builder, build, new Object[0]));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Object invoke(Object obj, Method method, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }
}

