/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.mockito;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.mockito.Mockito;

public final class MockitoCustomizer
implements Customizer {
    public ObjectGenerator customize(ObjectGenerator generator) {
        return (query, context) -> this.generate(query.getType()).yieldIfEmpty(() -> generator.generate(query, context));
    }

    private ObjectContainer generate(Type type) {
        return type instanceof Class ? this.generate((Class)type) : (type instanceof ParameterizedType ? this.generate((ParameterizedType)type) : ObjectContainer.EMPTY);
    }

    private ObjectContainer generate(Class<?> type) {
        return this.isAbstract(type) ? new ObjectContainer(Mockito.mock(type)) : ObjectContainer.EMPTY;
    }

    private ObjectContainer generate(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        return type instanceof Class ? this.generate((Class)type) : ObjectContainer.EMPTY;
    }

    private boolean isAbstract(Class<?> type) {
        return type.isInterface() || !type.isPrimitive() && Modifier.isAbstract(type.getModifiers());
    }
}

