/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.javaunit.autoparams.Fixed;
import org.javaunit.autoparams.FixedValueAccessor;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

final class ArgumentsAssembler {
    ArgumentsAssembler() {
    }

    public static Stream<? extends Arguments> assembleArguments(ExtensionContext context, ArgumentsProvider ... providers) {
        return ArgumentsAssembler.foldl((sets, provider) -> sets.flatMap(set -> ArgumentsAssembler.supplementArguments(set, provider, context)), Stream.of(Arguments.of((Object[])new Object[0])), Arrays.stream(providers));
    }

    private static <T, U> U foldl(BiFunction<U, T, U> f, U z, Stream<T> xs) {
        Iterator i = xs.iterator();
        U a = z;
        while (i.hasNext()) {
            a = f.apply(a, i.next());
        }
        return a;
    }

    private static Stream<? extends Arguments> supplementArguments(Arguments source, ArgumentsProvider provider, ExtensionContext context) {
        try {
            return provider.provideArguments(context).map(supplement -> {
                ArgumentsAssembler.setFixedValues(context, supplement);
                return ArgumentsAssembler.coalesceArguments(source, supplement);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setFixedValues(ExtensionContext context, Arguments supplement) {
        context.getTestMethod().map(method -> method.getParameters()).ifPresent(parameters -> {
            Object[] arguments = supplement.get();
            for (int i = 0; i < arguments.length; ++i) {
                ArgumentsAssembler.setIfFixed(context, parameters[i], arguments[i]);
            }
        });
    }

    private static void setIfFixed(ExtensionContext context, Parameter parameter, Object argument) {
        if (parameter.isAnnotationPresent(Fixed.class)) {
            FixedValueAccessor.set(context, parameter.getType(), argument);
        }
    }

    private static Arguments coalesceArguments(Arguments source, Arguments supplement) {
        ArrayList arguments = new ArrayList();
        Collections.addAll(arguments, source.get());
        Arrays.stream(supplement.get()).skip(arguments.size()).forEach(arguments::add);
        return Arguments.of((Object[])arguments.toArray());
    }
}

