/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.Array;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectGenerator;
import org.javaunit.autoparams.ObjectQuery;

final class ArrayGenerator
implements ObjectGenerator {
    ArrayGenerator() {
    }

    @Override
    public GenerationResult generate(ObjectQuery query, ObjectGenerationContext context) {
        Class<?> type = query.getType();
        return type.isArray() ? GenerationResult.presence(this.factory(type, context)) : GenerationResult.absence();
    }

    private Object factory(Class<?> type, ObjectGenerationContext context) {
        Class<?> componentType = type.getComponentType();
        int length = 3;
        Object array = Array.newInstance(componentType, length);
        ObjectQuery query = new ObjectQuery(componentType);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, context.generate(query));
        }
        return array;
    }
}

