/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.javaunit.autoparams.AutoSource;
import org.javaunit.autoparams.BuilderGenerator;
import org.javaunit.autoparams.CollectionGenerator;
import org.javaunit.autoparams.ComplexObjectGenerator;
import org.javaunit.autoparams.CompositeObjectGenerator;
import org.javaunit.autoparams.Fixed;
import org.javaunit.autoparams.FixedValueAccessor;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectQuery;
import org.javaunit.autoparams.PrimitiveValueGenerator;
import org.javaunit.autoparams.SimpleValueObjectGenerator;
import org.javaunit.autoparams.StreamGenerator;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

final class AutoArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<AutoSource> {
    private static final Stream<Arguments> EMPTY = Arrays.stream(new Arguments[0]);
    public static final CompositeObjectGenerator DEFAULT_OBJECT_GENERATOR = new CompositeObjectGenerator(new PrimitiveValueGenerator(), new SimpleValueObjectGenerator(), new CollectionGenerator(), new StreamGenerator(), new BuilderGenerator(), new ComplexObjectGenerator());
    private final ObjectGenerationContext context;
    private int repeat;

    public AutoArgumentsProvider() {
        this(new ObjectGenerationContext(DEFAULT_OBJECT_GENERATOR));
    }

    private AutoArgumentsProvider(ObjectGenerationContext context) {
        this.context = context;
        this.repeat = 1;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        this.applyFixedValues(context);
        return context.getTestMethod().map(this::generate).orElse(EMPTY);
    }

    private void applyFixedValues(ExtensionContext context) {
        for (Map.Entry<Class<?>, Object> entry : FixedValueAccessor.entries(context)) {
            this.context.fix(entry.getKey(), entry.getValue());
        }
    }

    private Stream<Arguments> generate(Method method) {
        Arguments[] streamSource = new Arguments[this.repeat];
        for (int i = 0; i < streamSource.length; ++i) {
            streamSource[i] = this.createArguments(method);
        }
        return Arrays.stream(streamSource);
    }

    private Arguments createArguments(Method method) {
        Parameter[] parameters = method.getParameters();
        Object[] arguments = Arrays.stream(parameters).map(this::createArgument).toArray();
        return Arguments.of((Object[])arguments);
    }

    private Object createArgument(Parameter parameter) {
        ObjectQuery query = ObjectQuery.create(parameter);
        Object argument = this.context.generate(query);
        if (parameter.isAnnotationPresent(Fixed.class)) {
            this.context.fix(parameter.getType(), argument);
        }
        return argument;
    }

    public void accept(AutoSource annotation) {
        this.repeat = annotation.repeat();
    }
}

