/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.javaunit.autoparams.GenericObjectQuery;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectQuery;

public final class Builder<T> {
    private final GenericObjectQuery builderQuery;
    private final ObjectGenerationContext context;

    Builder(GenericObjectQuery builderQuery, ObjectGenerationContext context) {
        this.builderQuery = builderQuery;
        this.context = context;
    }

    public T build() {
        return this.generate(this.builderQuery);
    }

    private T generate(GenericObjectQuery builderQuery) {
        ObjectQuery query = this.createGenerateObjectQuery(builderQuery);
        return (T)this.context.generate(query);
    }

    private ObjectQuery createGenerateObjectQuery(GenericObjectQuery builderQuery) {
        Type generateType = builderQuery.getParameterizedType().getActualTypeArguments()[0];
        if (generateType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)generateType;
            return new GenericObjectQuery((Class)parameterizedType.getRawType(), parameterizedType);
        }
        return new ObjectQuery((Class)generateType);
    }
}

