/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

final class ComplexObjectConstructorResolver {
    ComplexObjectConstructorResolver() {
    }

    public static Optional<Constructor<?>> resolveConstructor(Class<?> type) {
        ConstructorSelector[] selectors;
        for (ConstructorSelector selector : selectors = new ConstructorSelector[]{source -> ComplexObjectConstructorResolver.selectWithFewestParameters(ComplexObjectConstructorResolver.filterDecoratedWithConstructorProperties(source)), source -> ComplexObjectConstructorResolver.selectWithFewestParameters(source)}) {
            Optional<Constructor<?>> constructor = selector.select(type.getConstructors());
            if (!constructor.isPresent()) continue;
            return constructor;
        }
        return Optional.empty();
    }

    private static Optional<Constructor<?>> selectWithFewestParameters(Constructor<?>[] constructors) {
        return Arrays.stream(constructors).sorted(Comparator.comparing(c -> c.getParameterCount())).findFirst();
    }

    private static Constructor<?>[] filterDecoratedWithConstructorProperties(Constructor<?>[] constructors) {
        return (Constructor[])Arrays.stream(constructors).filter(c -> c.isAnnotationPresent(ConstructorProperties.class)).toArray(Constructor[]::new);
    }

    static interface ConstructorSelector {
        public Optional<Constructor<?>> select(Constructor<?>[] var1);
    }
}

