/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.javaunit.autoparams.ComplexObjectConstructorResolver;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.GenericObjectQuery;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectGenerator;
import org.javaunit.autoparams.ObjectQuery;

final class ComplexObjectGenerator
implements ObjectGenerator {
    ComplexObjectGenerator() {
    }

    @Override
    public GenerationResult generate(ObjectQuery query, ObjectGenerationContext context) {
        if (this.isAbstractType(query.getType())) {
            return GenerationResult.absence();
        }
        return ComplexObjectConstructorResolver.resolveConstructor(query.getType()).map(constructor -> this.generate(query, (Constructor<?>)constructor, context)).map(GenerationResult::presence).orElse(GenerationResult.absence());
    }

    private Object generate(ObjectQuery sourceQuery, Constructor<?> constructor, ObjectGenerationContext context) {
        Parameter[] parameters = constructor.getParameters();
        Stream<ObjectQuery> argumentQueries = this.resolveArgumentQueries(sourceQuery, parameters);
        return this.createInstance(constructor, argumentQueries, context);
    }

    private boolean isAbstractType(Class<?> type) {
        return type.isInterface() || Modifier.isAbstract(type.getModifiers());
    }

    private Stream<ObjectQuery> resolveArgumentQueries(ObjectQuery sourceQuery, Parameter[] parameters) {
        if (sourceQuery instanceof GenericObjectQuery) {
            return this.resolveArgumentQueries((GenericObjectQuery)sourceQuery, parameters);
        }
        return this.resolveArgumentQueries(parameters);
    }

    private Stream<ObjectQuery> resolveArgumentQueries(GenericObjectQuery genericObjectQuery, Parameter[] parameters) {
        Class<?> type = genericObjectQuery.getType();
        ParameterizedType parameterizedType = genericObjectQuery.getParameterizedType();
        Map<TypeVariable<?>, Type> genericMap = this.getGenericMap(type, parameterizedType);
        return Arrays.stream(parameters).map(parameter -> this.resolveArgumentQuery((Parameter)parameter, genericMap));
    }

    private Stream<ObjectQuery> resolveArgumentQueries(Parameter[] parameters) {
        return Arrays.stream(parameters).map(ObjectQuery::create);
    }

    private Map<TypeVariable<?>, Type> getGenericMap(Class<?> type, ParameterizedType parameterizedType) {
        HashMap map = new HashMap();
        TypeVariable<Class<?>>[] typeVariables = type.getTypeParameters();
        Type[] typeValues = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], typeValues[i]);
        }
        return map;
    }

    private ObjectQuery resolveArgumentQuery(Parameter parameter, Map<TypeVariable<?>, Type> genericMap) {
        if (parameter.getParameterizedType() instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)parameter.getParameterizedType();
            Type typeValue = genericMap.get(typeVariable);
            if (typeValue instanceof ParameterizedType) {
                Class type = (Class)typeVariable.getGenericDeclaration();
                ParameterizedType parameterizedType = (ParameterizedType)typeValue;
                return new GenericObjectQuery(type, parameterizedType);
            }
            return new ObjectQuery((Class)typeValue);
        }
        return ObjectQuery.create(parameter);
    }

    private Object createInstance(Constructor<?> constructor, Stream<ObjectQuery> argumentQueries, ObjectGenerationContext context) {
        try {
            return constructor.newInstance(this.generateArguments(argumentQueries, context));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] generateArguments(Stream<ObjectQuery> argumentQueries, ObjectGenerationContext context) {
        return argumentQueries.map(context::generate).toArray();
    }
}

