/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.util.concurrent.ThreadLocalRandom;
import org.javaunit.autoparams.EnumValuesResolver;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectGenerator;
import org.javaunit.autoparams.ObjectQuery;

final class EnumGenerator
implements ObjectGenerator {
    EnumGenerator() {
    }

    @Override
    public GenerationResult generate(ObjectQuery query, ObjectGenerationContext context) {
        Class<?> superType = query.getType().getSuperclass();
        return superType != null && superType.equals(Enum.class) ? GenerationResult.presence(this.factory(query.getType())) : GenerationResult.absence();
    }

    private Object factory(Class<?> type) {
        Object[] values = EnumValuesResolver.resolveValues(type);
        int index = ThreadLocalRandom.current().nextInt(values.length);
        return values[index];
    }
}

