/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

final class Factories {
    Factories() {
    }

    private static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }

    public static boolean createBoolean() {
        return Factories.random().nextInt() % 2 == 0;
    }

    public static byte createByte() {
        return (byte)Factories.random().nextInt(-128, 128);
    }

    public static short createShort() {
        return (short)Factories.random().nextInt(Short.MIN_VALUE, 32768);
    }

    public static int createInt() {
        return Factories.random().nextInt();
    }

    public static long createLong() {
        return Factories.random().nextLong();
    }

    public static float createFloat() {
        return Factories.random().nextFloat();
    }

    public static double createDouble() {
        return Factories.random().nextDouble();
    }

    public static char createChar() {
        return (char)Factories.random().nextInt(65536);
    }

    public static BigInteger createBigInteger() {
        int maxBitLength = 256;
        return new BigInteger(maxBitLength, Factories.random());
    }

    public static BigDecimal createBigDecimal() {
        return new BigDecimal(Factories.random().nextInt());
    }

    public static LocalDate createLocalDate() {
        long inclusiveMin = LocalDate.MIN.toEpochDay();
        long exclusiveMax = LocalDate.MAX.toEpochDay() + 1L;
        long randomEpochDay = Factories.random().nextLong(inclusiveMin, exclusiveMax);
        return LocalDate.ofEpochDay(randomEpochDay);
    }

    public static LocalTime createLocalTime() {
        long inclusiveMin = LocalTime.MIN.toNanoOfDay();
        long exclusiveMax = LocalTime.MAX.toNanoOfDay() + 1L;
        long randomNanoOfDay = Factories.random().nextLong(inclusiveMin, exclusiveMax);
        return LocalTime.ofNanoOfDay(randomNanoOfDay);
    }

    public static LocalDateTime createLocalDateTime() {
        return LocalDateTime.of(Factories.createLocalDate(), Factories.createLocalTime());
    }

    public static Class<?> createClass() {
        return String.class;
    }

    public static IntStream createIntStream() {
        return IntStream.generate(Factories::createInt).limit(3L);
    }

    public static LongStream createLongStream() {
        return LongStream.generate(Factories::createLong).limit(3L);
    }

    public static DoubleStream createDoubleStream() {
        return DoubleStream.generate(Factories::createDouble).limit(3L);
    }
}

