/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.util.HashMap;
import java.util.Map;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.GenericObjectGenerator;
import org.javaunit.autoparams.GenericObjectQuery;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectQuery;

final class MapGenerator
extends GenericObjectGenerator {
    MapGenerator() {
    }

    private boolean isMap(Class<?> type) {
        return type.equals(HashMap.class) || type.equals(Map.class);
    }

    private Object factory(GenericObjectQuery query, ObjectGenerationContext context) {
        return this.factory(this.getKeyType(query), this.getValueType(query), context);
    }

    private <K, V> HashMap<K, V> factory(Class<? extends K> keyType, Class<? extends V> valueType, ObjectGenerationContext context) {
        HashMap<Object, Object> instance = new HashMap<Object, Object>();
        int size = 3;
        ObjectQuery keyQuery = new ObjectQuery(keyType);
        ObjectQuery valueQuery = new ObjectQuery(valueType);
        for (int i = 0; i < size; ++i) {
            instance.put(context.generate(keyQuery), context.generate(valueQuery));
        }
        return instance;
    }

    private Class<?> getKeyType(GenericObjectQuery query) {
        return (Class)query.getParameterizedType().getActualTypeArguments()[0];
    }

    private Class<?> getValueType(GenericObjectQuery query) {
        return (Class)query.getParameterizedType().getActualTypeArguments()[1];
    }

    @Override
    protected GenerationResult generate(GenericObjectQuery query, ObjectGenerationContext context) {
        return this.isMap(query.getType()) ? GenerationResult.presence(this.factory(query, context)) : GenerationResult.absence();
    }
}

