/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import javax.annotation.Nullable;
import org.javaunit.autoparams.CompositeObjectGenerator;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.ObjectGenerationException;
import org.javaunit.autoparams.ObjectGenerator;
import org.javaunit.autoparams.ObjectQuery;
import org.javaunit.autoparams.TypeMatchingGenerator;

final class ObjectGenerationContext {
    private ObjectGenerator generator;

    public ObjectGenerationContext(ObjectGenerator generator) {
        this.generator = generator;
    }

    @Nullable
    public Object generate(ObjectQuery query) {
        GenerationResult result = this.generator.generate(query, this);
        if (result.isAbsent()) {
            String format = "An object cannot be generated with the given query '%s'. This can happen if the query represents an interface or abstract class.";
            throw new ObjectGenerationException(String.format(format, query.getType()));
        }
        return result.get();
    }

    void fix(Class<?> type, Object argument) {
        this.generator = new CompositeObjectGenerator(new TypeMatchingGenerator(() -> argument, type), this.generator);
    }
}

