/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.GenericObjectGenerator;
import org.javaunit.autoparams.GenericObjectQuery;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectQuery;

final class SequenceGenerator
extends GenericObjectGenerator {
    SequenceGenerator() {
    }

    private static boolean isCollection(Class<?> type) {
        return type.equals(ArrayList.class) || type.equals(List.class) || type.equals(Collection.class) || type.equals(Iterable.class);
    }

    private static Class<?> getComponentType(GenericObjectQuery query) {
        return (Class)query.getParameterizedType().getActualTypeArguments()[0];
    }

    public static <T> ArrayList<T> factory(Class<? extends T> componentType, ObjectGenerationContext context) {
        ArrayList<Object> instance = new ArrayList<Object>();
        int size = 3;
        ObjectQuery query = new ObjectQuery(componentType);
        for (int i = 0; i < size; ++i) {
            instance.add(context.generate(query));
        }
        return instance;
    }

    @Override
    protected GenerationResult generate(GenericObjectQuery query, ObjectGenerationContext context) {
        return SequenceGenerator.isCollection(query.getType()) ? GenerationResult.presence(SequenceGenerator.factory(SequenceGenerator.getComponentType(query), context)) : GenerationResult.absence();
    }
}

