/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.util.function.Function;
import java.util.function.Supplier;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectGenerator;
import org.javaunit.autoparams.ObjectQuery;

class TypeMatchingGenerator
implements ObjectGenerator {
    private final Function<Class<?>, Boolean> predicate;
    private final Supplier<Object> factory;

    public TypeMatchingGenerator(Function<Class<?>, Boolean> predicate, Supplier<Object> factory) {
        this.predicate = predicate;
        this.factory = factory;
    }

    public TypeMatchingGenerator(Supplier<Object> factory, Class<?> ... types) {
        this(TypeMatchingGenerator.buildPredicateWithTypes(types), factory);
    }

    private static Function<Class<?>, Boolean> buildPredicateWithTypes(Class<?> ... types) {
        return queryType -> {
            for (Class type : types) {
                if (!queryType.equals(type)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public final GenerationResult generate(ObjectQuery query, ObjectGenerationContext context) {
        return this.predicate.apply(query.getType()) != false ? GenerationResult.presence(this.factory.get()) : GenerationResult.absence();
    }
}

