/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ThreadLocalRandom;
import org.javaunit.autoparams.GenerationResult;
import org.javaunit.autoparams.ObjectGenerationContext;
import org.javaunit.autoparams.ObjectGenerator;
import org.javaunit.autoparams.ObjectQuery;

final class UrlGenerator
implements ObjectGenerator {
    private static final String[] PROTOCOLS = new String[]{"http", "https", "ftp"};

    UrlGenerator() {
    }

    @Override
    public GenerationResult generate(ObjectQuery query, ObjectGenerationContext context) {
        return query.getType().equals(URL.class) ? GenerationResult.presence(this.generate()) : GenerationResult.absence();
    }

    private URL generate() {
        int index = ThreadLocalRandom.current().nextInt(PROTOCOLS.length);
        String urlSource = String.format("%s://auto.params", PROTOCOLS[index]);
        try {
            return new URL(urlSource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

