/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.javaunit.autoparams.Customizers;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

final class ArgumentsAssembler {
    ArgumentsAssembler() {
    }

    public static Stream<? extends Arguments> assembleArguments(ExtensionContext context, ArgumentsProvider ... providers) {
        return ArgumentsAssembler.foldl((sets, provider) -> sets.flatMap(set -> ArgumentsAssembler.supplementArguments(set, provider, context)), Stream.of(Arguments.of((Object[])new Object[0])), Arrays.stream(providers));
    }

    private static <T, U> U foldl(BiFunction<U, T, U> f, U z, Stream<T> xs) {
        Iterator i = xs.iterator();
        U a = z;
        while (i.hasNext()) {
            a = f.apply(a, i.next());
        }
        return a;
    }

    private static Stream<? extends Arguments> supplementArguments(Arguments source, ArgumentsProvider provider, ExtensionContext context) {
        try {
            return provider.provideArguments(context).map(supplement -> {
                ArgumentsAssembler.processArguments(context, supplement);
                return ArgumentsAssembler.coalesceArguments(source, supplement);
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void processArguments(ExtensionContext context, Arguments supplement) {
        context.getTestMethod().map(method -> method.getParameters()).ifPresent(parameters -> {
            Object[] arguments = supplement.get();
            for (int i = 0; i < arguments.length; ++i) {
                Parameter parameter = parameters[i];
                ArgumentsAssembler.processArgument(context, parameter, ArgumentsAssembler.convertArgument(parameter, arguments[i]));
            }
        });
    }

    private static Object convertArgument(Parameter parameter, Object argument) {
        return DefaultArgumentConverter.INSTANCE.convert(argument, parameter.getType());
    }

    private static void processArgument(ExtensionContext context, Parameter parameter, Object argument) {
        Customizers.processArgument(parameter, argument).forEach(customizer -> Customizers.addCustomizer(context, customizer));
    }

    private static Arguments coalesceArguments(Arguments source, Arguments supplement) {
        ArrayList arguments = new ArrayList();
        Collections.addAll(arguments, source.get());
        Arrays.stream(supplement.get()).skip(arguments.size()).forEach(arguments::add);
        return Arguments.of((Object[])arguments.toArray());
    }
}

