/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.stream.Stream;
import org.javaunit.autoparams.Customizers;
import org.javaunit.autoparams.customization.Customization;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectQuery;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;

final class ArgumentsGenerator {
    private final ObjectGenerationContext context;
    private final int repeat;

    public ArgumentsGenerator(ObjectGenerationContext context, int repeat) {
        this.context = context;
        this.repeat = repeat;
    }

    public Stream<? extends Arguments> generateArguments(ExtensionContext context) {
        this.customizeGenerator(context);
        return this.generate(context.getRequiredTestMethod());
    }

    private void customizeGenerator(ExtensionContext context) {
        this.customizeGenerator(context.getRequiredTestMethod());
        Customizers.getCustomizers(context).forEach(this.context::customizeGenerator);
    }

    private void customizeGenerator(AnnotatedElement annotated) {
        Customization customization = annotated.getAnnotation(Customization.class);
        if (customization != null) {
            this.customizeGenerator(customization);
        }
    }

    private void customizeGenerator(Customization customization) {
        for (Class<? extends Customizer> customizerType : customization.value()) {
            this.customizeGenerator(customizerType);
        }
    }

    private void customizeGenerator(Class<? extends Customizer> customizerType) {
        try {
            this.context.customizeGenerator(customizerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            return;
        }
    }

    private Stream<Arguments> generate(Method method) {
        Arguments[] streamSource = new Arguments[this.repeat];
        for (int i = 0; i < streamSource.length; ++i) {
            streamSource[i] = this.createArguments(method);
        }
        return Arrays.stream(streamSource);
    }

    private Arguments createArguments(Method method) {
        Parameter[] parameters = method.getParameters();
        Stream<Object> arguments = Arrays.stream(parameters).map(this::createThenProcessArgument);
        return Arguments.of((Object[])arguments.toArray());
    }

    private Object createThenProcessArgument(Parameter parameter) {
        this.customizeGenerator(parameter);
        Object argument = this.context.generate(ObjectQuery.fromParameter(parameter));
        Customizers.processArgument(parameter, argument).forEach(this.context::customizeGenerator);
        return argument;
    }
}

