/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.customization;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

public final class SettablePropertyWriter
implements Customizer {
    @Override
    public ObjectGenerator customize(ObjectGenerator generator) {
        return (query, context) -> {
            ObjectContainer container = generator.generate(query, context);
            if (query.getType() instanceof Class) {
                SettablePropertyWriter.writePropertiesNonGeneric((Class)query.getType(), container.unwrapOrElseThrow(), context);
            } else if (query.getType() instanceof ParameterizedType) {
                SettablePropertyWriter.writePropertiesGeneric((ParameterizedType)query.getType(), container.unwrapOrElseThrow(), context);
            }
            return container;
        };
    }

    private static void writePropertiesNonGeneric(Class<?> type, Object obj, ObjectGenerationContext context) {
        try {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                Method method = descriptor.getWriteMethod();
                if (method == null) continue;
                Parameter parameter = method.getParameters()[0];
                ObjectQuery writerValueQuery = ObjectQuery.fromParameter(parameter);
                Object writerValue = context.generate(writerValueQuery);
                method.invoke(obj, writerValue);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writePropertiesGeneric(ParameterizedType parameterizedType, Object obj, ObjectGenerationContext context) {
        try {
            PropertyDescriptor[] descriptors;
            Class type = (Class)parameterizedType.getRawType();
            Map<TypeVariable<?>, Type> genericMap = SettablePropertyWriter.getGenericMap(type, parameterizedType);
            for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                Method method = descriptor.getWriteMethod();
                if (method == null) continue;
                ObjectQuery query = SettablePropertyWriter.resolveArgumentQuery(method, genericMap);
                Object writerValue = context.generate(query);
                method.invoke(obj, writerValue);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Map<TypeVariable<?>, Type> getGenericMap(Class<?> type, ParameterizedType parameterizedType) {
        HashMap map = new HashMap();
        TypeVariable<Class<?>>[] typeVariables = type.getTypeParameters();
        Type[] typeValues = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], typeValues[i]);
        }
        return map;
    }

    private static ObjectQuery resolveArgumentQuery(Method method, Map<TypeVariable<?>, Type> genericMap) {
        Type parameterType = method.getGenericParameterTypes()[0];
        return parameterType instanceof TypeVariable && genericMap.containsKey((TypeVariable)parameterType) ? () -> (Type)genericMap.get((TypeVariable)parameterType) : () -> method.getParameterTypes()[0];
    }
}

