/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.javaunit.autoparams.Builder;
import org.javaunit.autoparams.generator.ConstructorResolver;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class ComplexObjectGenerator
implements ObjectGenerator {
    ComplexObjectGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        if (query.getType() instanceof Class) {
            return this.generateNonGeneric((Class)query.getType(), context);
        }
        if (query.getType() instanceof ParameterizedType) {
            return this.generateGeneric((ParameterizedType)query.getType(), context);
        }
        return ObjectContainer.EMPTY;
    }

    private ObjectContainer generateNonGeneric(Class<?> type, ObjectGenerationContext context) {
        if (this.isAbstract(type)) {
            return ObjectContainer.EMPTY;
        }
        Constructor<?> constructor = this.resolveConstructor(type);
        Stream<ObjectQuery> argumentQueries = Arrays.stream(constructor.getParameters()).map(ObjectQuery::fromParameter);
        return new ObjectContainer(this.createInstance(constructor, argumentQueries, context));
    }

    private ObjectContainer generateGeneric(ParameterizedType parameterizedType, ObjectGenerationContext context) {
        Class type = (Class)parameterizedType.getRawType();
        if (this.isAbstract(type) || type.equals(Builder.class)) {
            return ObjectContainer.EMPTY;
        }
        Map<TypeVariable<?>, Type> genericMap = this.getGenericMap(type, parameterizedType);
        Constructor<?> constructor = this.resolveConstructor(type);
        Stream<ObjectQuery> argumentQueries = Arrays.stream(constructor.getParameters()).map(parameter -> this.resolveArgumentQuery((Parameter)parameter, genericMap));
        return new ObjectContainer(this.createInstance(constructor, argumentQueries, context));
    }

    private boolean isAbstract(Class<?> type) {
        return type.isInterface() || Modifier.isAbstract(type.getModifiers());
    }

    private Constructor<?> resolveConstructor(Class<?> type) {
        return ConstructorResolver.compose(t -> Arrays.stream(t.getConstructors()).filter(c -> c.isAnnotationPresent(ConstructorProperties.class)).sorted(Comparator.comparing(c -> c.getParameterCount())).findFirst(), t -> Arrays.stream(t.getConstructors()).sorted(Comparator.comparing(c -> c.getParameterCount())).findFirst()).resolve(type).get();
    }

    private Map<TypeVariable<?>, Type> getGenericMap(Class<?> type, ParameterizedType parameterizedType) {
        HashMap map = new HashMap();
        TypeVariable<Class<?>>[] typeVariables = type.getTypeParameters();
        Type[] typeValues = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], typeValues[i]);
        }
        return map;
    }

    private ObjectQuery resolveArgumentQuery(Parameter parameter, Map<TypeVariable<?>, Type> genericMap) {
        return parameter.getParameterizedType() instanceof TypeVariable ? () -> (Type)genericMap.get((TypeVariable)parameter.getParameterizedType()) : ObjectQuery.fromParameter(parameter);
    }

    private Object createInstance(Constructor<?> constructor, Stream<ObjectQuery> argumentQueries, ObjectGenerationContext context) {
        try {
            return constructor.newInstance(this.generateArguments(argumentQueries, context));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] generateArguments(Stream<ObjectQuery> argumentQueries, ObjectGenerationContext context) {
        return argumentQueries.map(query -> context.getGenerator().generate((ObjectQuery)query, context)).map(ObjectContainer::unwrapOrElseThrow).toArray();
    }
}

