/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.javaunit.autoparams.generator.ArgumentQuery;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class DoubleGenerator
implements ObjectGenerator {
    DoubleGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        if (type == Double.TYPE || type == Double.class) {
            double origin = this.getOrigin(query);
            double bound = this.getBound(query);
            double value = ThreadLocalRandom.current().nextDouble(origin, bound);
            return new ObjectContainer(value);
        }
        return ObjectContainer.EMPTY;
    }

    private double getOrigin(ObjectQuery query) {
        ArgumentQuery argumentQuery;
        Min annotation;
        if (query instanceof ArgumentQuery && (annotation = (argumentQuery = (ArgumentQuery)query).getParameter().getAnnotation(Min.class)) != null) {
            return Math.max(Double.MIN_VALUE, (double)annotation.value());
        }
        return Double.MIN_VALUE;
    }

    private double getBound(ObjectQuery query) {
        ArgumentQuery argumentQuery;
        Max annotation;
        if (query instanceof ArgumentQuery && (annotation = (argumentQuery = (ArgumentQuery)query).getParameter().getAnnotation(Max.class)) != null) {
            return annotation.value();
        }
        return Double.MAX_VALUE;
    }
}

