/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.javaunit.autoparams.generator.ArgumentQuery;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class LongGenerator
implements ObjectGenerator {
    LongGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        return type == Long.TYPE || type == Long.class ? new ObjectContainer(this.factory(this.getMin(query), this.getMax(query))) : ObjectContainer.EMPTY;
    }

    private long getMin(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMin((ArgumentQuery)query) : Long.MIN_VALUE;
    }

    private long getMin(ArgumentQuery query) {
        Min annotation = query.getParameter().getAnnotation(Min.class);
        return annotation == null ? Long.MIN_VALUE : annotation.value();
    }

    private long getMax(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMax((ArgumentQuery)query) : Long.MAX_VALUE;
    }

    private long getMax(ArgumentQuery query) {
        Max annotation = query.getParameter().getAnnotation(Max.class);
        return annotation == null ? Long.MAX_VALUE : annotation.value();
    }

    private long factory(long min, long max) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (min == Long.MIN_VALUE && max == Long.MAX_VALUE) {
            return random.nextLong();
        }
        long offset = max == Long.MAX_VALUE ? -1L : 0L;
        long origin = min + offset;
        long bound = max + 1L + offset;
        return random.nextLong(origin, bound) - offset;
    }
}

